/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

    /* CKTmodCrt(type,name,ckt,fast)
     *  Create a device model of the specified type, with the given name
     *  in the named circuit.
     */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif


int
CKTmodCrt(ckt,type,modfast,name)
    GENERIC *ckt;
    int type;
    GENERIC **modfast;
    IFuid name;
{
    extern SPICEdev *DEVices[];
    GENmodel *mymodfast = NULL;
    int error;

    error = CKTfndMod(ckt,&type,(GENERIC**)&mymodfast,name);
    if(error == E_NOMOD) {
        mymodfast = (GENmodel *)MALLOC(*DEVices[type]->DEVmodSize);
        if(mymodfast == (GENmodel *)NULL) return(E_NOMEM);
        mymodfast->GENmodType = type;
        mymodfast->GENmodName = name;
        mymodfast->GENnextModel =(GENmodel *)((CKTcircuit *)ckt)->CKThead[type];
        ((CKTcircuit *)ckt)->CKThead[type]=(GENmodel *)mymodfast;
        if(modfast) *modfast=(GENERIC *)mymodfast;
        return(OK);
    } else if (error==0) {
        if(modfast) *modfast=(GENERIC *)mymodfast;
        return(E_EXISTS);
    } else {
        return(error);
    }
    /*NOTREACHED*/
}
