/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

extern SPICEanalysis *analInfo[];

/* ARGSUSED */
int
CKTnewAnal(ckt,type,name,analPtr,taskPtr)
    GENERIC *ckt;
    int type;
    IFuid name;
    GENERIC **analPtr;
    GENERIC *taskPtr;
{
    if(type==0) {
        /* special case for analysis type 0 == option card */
        *analPtr=taskPtr; /* pointer to the task itself */
        (*(JOB **)analPtr)->JOBname = name;
        (*(JOB **)analPtr)->JOBtype = type;
        return(OK); /* doesn't need to be created */
    }
    *analPtr = (GENERIC *)MALLOC(analInfo[type]->size);
    if(*analPtr==NULL) return(E_NOMEM);
    (*(JOB **)analPtr)->JOBname = name;
    (*(JOB **)analPtr)->JOBtype = type;
    (*(JOB **)analPtr)->JOBnextJob = ((TSKtask *)taskPtr)->jobs;
    ((TSKtask *)taskPtr)->jobs = (JOB *)*analPtr;
    return(OK);
}
