/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif

/* ARGSUSED */
int 
PZaskQuest(ckt,anal,which,value)
    CKTcircuit *ckt;
    GENERIC *anal;
    int which;
    IFvalue *value;
{
    switch(which) {

    case PZ_NODEI:
        value->nValue = (IFnode)CKTnum2nod(ckt,((PZAN*)anal)->PZin_pos);
        break;

    case PZ_NODEG:
        value->nValue = (IFnode)CKTnum2nod(ckt,((PZAN*)anal)->PZin_neg);
        break;

    case PZ_NODEJ:
        value->nValue = (IFnode)CKTnum2nod(ckt,((PZAN*)anal)->PZout_pos);
        break;

    case PZ_NODEK:
        value->nValue = (IFnode)CKTnum2nod(ckt,((PZAN*)anal)->PZout_neg);
        break;

    case PZ_V:
        if( ((PZAN*)anal)->PZinput_type == PZ_IN_VOL) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case PZ_I:
        if( ((PZAN*)anal)->PZinput_type == PZ_IN_CUR) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case PZ_POL:
        if( ((PZAN*)anal)->PZwhich == PZ_DO_POLES) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case PZ_ZER:
        if( ((PZAN*)anal)->PZwhich == PZ_DO_ZEROS) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    case PZ_PZ:
        if( ((PZAN*)anal)->PZwhich == (PZ_DO_POLES | PZ_DO_ZEROS)) {
            value->iValue=1;
        } else {
            value->iValue=0;
        }
        break;

    default:
        return(E_BADPARM);
    }
    return(OK);
}
