/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

/*
 * This routine deletes a BJT instance from the circuit and frees
 * the storage it was using.
 */

#include "spice.h"
#include "const.h"
#include "util.h"
#include <stdio.h>
#include "ifsim.h"
#include "cktdefs.h"
#include "devdefs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "bjtdefs.h"
#include "complex.h"
#include "trandefs.h"
#include "smpdefs.h"
#include "distodef.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop


int
BJTdelete(inModel,name,kill)
    GENmodel *inModel;
    IFuid name;
    GENinstance **kill;

{
    BJTmodel *model = (BJTmodel*)inModel;
    BJTinstance **fast = (BJTinstance**)kill;

    BJTinstance **prev = NULL;
    BJTinstance *here;

    for( ; model ; model = model->BJTnextModel) {
        prev = &(model->BJTinstances);
        for(here = *prev; here ; here = *prev) {
            if(here->BJTname == name || (fast && here==*fast) ) {
                *prev= here->BJTnextInstance;
                FREE(here);
                return(OK);
            }
            prev = &(here->BJTnextInstance);
        }
    }
    return(E_NODEV);
}
