/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include "devdefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include <stdio.h>
#include "smpdefs.h"
#include "inddefs.h"
#include "complex.h"
#include "util.h"
#include "sperror.h"
#include "trandefs.h"
#include "suffix.h"
#pragma hdrstop


/* ARGSUSED */
int
INDpzLoad(inModel,ckt,s)
    GENmodel *inModel;
    CKTcircuit *ckt;
    SPcomplex *s;
{
    register INDmodel *model = (INDmodel*)inModel;
    double val;
    register INDinstance *here;

    for( ; model != NULL; model = model->INDnextModel) {
        for( here = model->INDinstances;here != NULL; 
                here = here->INDnextInstance) {
    
            val = here->INDinduct;
            *(here->INDposIbrptr) += 1;
            *(here->INDnegIbrptr) -= 1;
            *(here->INDibrPosptr) += 1;
            *(here->INDibrNegptr) -= 1;
            *(here->INDibrIbrptr ) -= val * s->real;
            *(here->INDibrIbrptr +1) -= val * s->imag;
        }
    }
    return(OK);

}
