/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include "devdefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include <stdio.h>
#include "smpdefs.h"
#include "inddefs.h"
#include "complex.h"
#include "util.h"
#include "sperror.h"
#include "trandefs.h"
#include "suffix.h"
#pragma hdrstop


#ifdef MUTUAL
void
MUTdestroy(inModel)
    GENmodel **inModel;
{
    MUTmodel **model = (MUTmodel**)inModel;
    MUTinstance *here;
    MUTinstance *prev = NULL;
    MUTmodel *mod = *model;
    MUTmodel *oldmod = NULL;

    for( ; mod ; mod = mod->MUTnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (MUTinstance *)NULL;
        for(here = mod->MUTinstances ; here ; here = here->MUTnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
#endif /* MUTUAL */
