/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include "devdefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include <stdio.h>
#include "smpdefs.h"
#include "inddefs.h"
#include "complex.h"
#include "util.h"
#include "sperror.h"
#include "trandefs.h"
#include "suffix.h"
#pragma hdrstop


#ifdef MUTUAL
int
MUTmDelete(inModel,modname,kill)
    GENmodel **inModel;
    IFuid modname;
    GENmodel *kill;
{
    MUTmodel **model = (MUTmodel**)inModel;
    MUTmodel *modfast = (MUTmodel*)kill;
    MUTinstance *here;
    MUTinstance *prev = NULL;
    MUTmodel **oldmod;
    oldmod = model;
    for( ; *model ; model = &((*model)->MUTnextModel)) {
        if( (*model)->MUTmodName == modname || 
                (modfast && *model == modfast) ) goto delgot;
        oldmod = model;
    }
    return(E_NOMOD);

delgot:
    *oldmod = (*model)->MUTnextModel; /* cut deleted device out of list */
    for(here = (*model)->MUTinstances ; here ; here = here->MUTnextInstance) {
        if(prev) FREE(prev);
        prev = here;
    }
    if(prev) FREE(prev);
    FREE(*model);
    return(OK);

}
#endif /* MUTUAL */
