/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "util.h"
#include "const.h"
#include "complex.h"
#include "cktdefs.h"
#include "fteconst.h"
#include "smpdefs.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "ifsim.h"
#include "trandefs.h"
#include "devdefs.h"
#include "distodef.h"
#include "sperror.h"
#include "jfetdefs.h"
#include "suffix.h"
#pragma hdrstop


void
JFETdestroy(inModel)
    GENmodel **inModel;
{
    JFETmodel **model = (JFETmodel**)inModel;
    JFETinstance *here;
    JFETinstance *prev = NULL;
    JFETmodel *mod = *model;
    JFETmodel *oldmod = NULL;

    for( ; mod ; mod = mod->JFETnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (JFETinstance *)NULL;
        for(here = mod->JFETinstances ; here ; here = here->JFETnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
