/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1990 Jaijeet S. Roychowdhury
**********/

#include "spice.h"
#include <stdio.h>
#include "devdefs.h"
#include "smpdefs.h"
#include "const.h"
#include "util.h"
#include "cktdefs.h"
#include "trandefs.h"
#include "ifsim.h"
#include "ltradefs.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop

int
LTRAdelete(inModel,name,kill)
    GENmodel *inModel;
    IFuid name;
    GENinstance **kill;
{
    LTRAinstance **fast = (LTRAinstance **)kill;
    LTRAmodel *model = (LTRAmodel *)inModel;
    LTRAinstance **prev = NULL;
    LTRAinstance *here;

    for( ; model ; model = model->LTRAnextModel) {
        prev = &(model->LTRAinstances);
        for(here = *prev; here ; here = *prev) {
            if(here->LTRAname == name || (fast && here == *fast) ) {
                *prev= here->LTRAnextInstance;
                FREE(here);
                return(OK);
            }
            prev = &(here->LTRAnextInstance);
        }
    }
    return(E_NODEV);
}
