/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "devdefs.h"
#include "const.h"
#include "cktdefs.h"
#include "util.h"
#include "ifsim.h"
#include "mos2defs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "smpdefs.h"
#include "noisedef.h"
#include "complex.h"
#include "sperror.h"
#include "distodef.h"
#include "trandefs.h"
#include "suffix.h"
#pragma hdrstop


int
MOS2mDelete(inModel,modname,kill)
    GENmodel **inModel;
    IFuid modname;
    GENmodel *kill;
{
    MOS2model **model = (MOS2model **)inModel;
    MOS2model *modfast = (MOS2model *)kill;
    MOS2instance *here;
    MOS2instance *prev = NULL;
    MOS2model **oldmod;
    oldmod = model;
    for( ; *model ; model = &((*model)->MOS2nextModel)) {
        if( (*model)->MOS2modName == modname || 
                (modfast && *model == modfast) ) goto delgot;
        oldmod = model;
    }
    return(E_NOMOD);

delgot:
    *oldmod = (*model)->MOS2nextModel; /* cut deleted device out of list */
    for(here = (*model)->MOS2instances ; here ; here = here->MOS2nextInstance) {
        if(prev) FREE(prev);
        prev = here;
    }
    if(prev) FREE(prev);
    FREE(*model);
    return(OK);

}
