/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "const.h"
#include "devdefs.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "noisedef.h"
#include "complex.h"
#include "cktdefs.h"
#include "smpdefs.h"
#include "ifsim.h"
#include "util.h"
#include "trandefs.h"
#include "sperror.h"
#include "mos3defs.h"
#include "distodef.h"
#include "suffix.h"
#pragma hdrstop


void
MOS3destroy(inModel)
    GENmodel **inModel;
{
    MOS3model **model = (MOS3model **)inModel;
    MOS3instance *here;
    MOS3instance *prev = NULL;
    MOS3model *mod = *model;
    MOS3model *oldmod = NULL;

    for( ; mod ; mod = mod->MOS3nextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (MOS3instance *)NULL;
        for(here = mod->MOS3instances ; here ; here = here->MOS3nextInstance) {
            if(prev){
          if(prev->MOS3sens) FREE(prev->MOS3sens);
          FREE(prev);
            }
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
