/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Gordon Jacobs
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "devdefs.h"
#include "cktdefs.h"
#include "ifsim.h"
#include "util.h"
#include "fteconst.h"
#include "iferrmsg.h"
#include "smpdefs.h"
#include "complex.h"
#include "noisedef.h"
#include "sperror.h"
#include "trandefs.h"
#include "swdefs.h"
#include "suffix.h"
#pragma hdrstop


void
SWdestroy(inModel)
    GENmodel **inModel;
{
    SWmodel **model = (SWmodel**)inModel;
    SWinstance *here;
    SWinstance *prev = NULL;
    SWmodel *mod = *model;
    SWmodel *oldmod = NULL;

    for( ; mod ; mod = mod->SWnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (SWinstance *)NULL;
        for(here = mod->SWinstances ; here ; here = here->SWnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
