/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "complex.h"
#include "vccsdefs.h"
#include "smpdefs.h"
#include "sperror.h"
#include "util.h"
#include "suffix.h"
#pragma hdrstop


int
VCCSmDelete(inModel,modname,kill)
    GENmodel **inModel;
    IFuid modname;
    GENmodel *kill;
{
    VCCSmodel **model = (VCCSmodel **)inModel;
    VCCSmodel *modfast = (VCCSmodel *)kill;
    VCCSinstance *here;
    VCCSinstance *prev = NULL;
    VCCSmodel **oldmod;
    oldmod = model;
    for( ; *model ; model = &((*model)->VCCSnextModel)) {
        if( (*model)->VCCSmodName == modname || 
                (modfast && *model == modfast) ) goto delgot;
        oldmod = model;
    }
    return(E_NOMOD);

delgot:
    *oldmod = (*model)->VCCSnextModel; /* cut deleted device out of list */
    for(here = (*model)->VCCSinstances ; here ; here = here->VCCSnextInstance) {
        if(prev) FREE(prev);
        prev = here;
    }
    if(prev) FREE(prev);
    FREE(*model);
    return(OK);

}
