/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "ifsim.h"
#include "devdefs.h"
#include "smpdefs.h"
#include "complex.h"
#include "trandefs.h"
#include "vcvsdefs.h"
#include "sperror.h"
#include "util.h"
#include "suffix.h"
#pragma hdrstop


void
VCVSdestroy(inModel)
    GENmodel **inModel;
{
    VCVSmodel **model = (VCVSmodel **)inModel;
    VCVSinstance *here;
    VCVSinstance *prev = NULL;
    VCVSmodel *mod = *model;
    VCVSmodel *oldmod = NULL;

    for( ; mod ; mod = mod->VCVSnextModel) {
        if(oldmod) FREE(oldmod);
        oldmod = mod;
        prev = (VCVSinstance *)NULL;
        for(here = mod->VCVSinstances ; here ; here = here->VCVSnextInstance) {
            if(prev) FREE(prev);
            prev = here;
        }
        if(prev) FREE(prev);
    }
    if(oldmod) FREE(oldmod);
    *model = NULL;
}
