/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

/* 
 *  provide the error message appropriate for the given error code
 */

#include "spice.h"
#include <stdio.h>
#include <ctype.h>
#include "util.h"
#include "misc.h"
#include "inpdefs.h"
#include "inpmacs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "inpptree.h"
#include "cpdefs.h"
#include "cpstd.h"
#include "fteext.h"
#include "ftedefs.h"
#include "tskdefs.h"
#include "strext.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop

char *
INPerror(type)
    int type;
{
    char *val;
    char ebuf[513];

    val = SPerror(type);

    if (!val)
        return(val);

    if(errRtn)
	sprintf(ebuf, "%s detected in routine \"%s\"\n", val, errRtn);
    else
	sprintf(ebuf, "%s\n", val);

    FREE(val);
    val = MALLOC(strlen(ebuf) + 1);
    if (val)
	strcpy(val, ebuf);

    return(val);
}
    
