use strict;
use warnings;
use Device::SerialPort;

my $num_args = $#ARGV + 1;
if ($num_args != 1) {
  die "Bitte seriellen Port angeben.";
}

my $serial_port = $ARGV[0];
my $arduino = Device::SerialPort->new($serial_port); 
$arduino->baudrate(9600);
$arduino->databits(8);
$arduino->parity("none");
$arduino->stopbits(1);
$arduino->read_const_time(1); 
$arduino->read_char_time(1);

sleep(2);
while (1) {
  my ($count, $line) = $arduino->read(255);
  if ($line =~ /^\$GPRMC/) {
  	my @attr = split(',', $line);
  	if ($#attr > 6 && $attr[2] eq "A") {
      print $line;
    }
  }
}
