import java.io.*;
import gnu.io.*; 

class GpsReader {
  private BufferedReader _gpsData;

  public GpsReader(
    final String portName) throws Exception 
  {
    final int timeout = 1000;
    final String appName = "GPS reader";
    CommPortIdentifier portId = 
      CommPortIdentifier.getPortIdentifier(portName);
    SerialPort port = (SerialPort)portId.open(
      appName,
      timeout
    );
    _gpsData = new BufferedReader(new InputStreamReader(port.getInputStream()));
    port.setSerialPortParams(
      9600,
      SerialPort.DATABITS_8,
      SerialPort.STOPBITS_1,
      SerialPort.PARITY_NONE
    );
  }

  public void run() throws Exception {
    while (true) {
      System.out.println(_gpsData.readLine());
    }
  }

  public static void main(String[] args) throws Exception {
    if (args.length != 1) {
      System.out.println(
        "Bitte seriellen Port angeben."
      );
      System.exit(1);
    }
    GpsReader gpsReader = new GpsReader(args[0]);
    gpsReader.run();
  }
}
