package de.jockels.lib;

import java.util.ArrayList;

import android.util.Log;

/**
 * Ein Nachbau von TimingLogger mit zwei Unterschieden:
 * 
 * 1) Es wird nicht ber den isLoggable-Mechanismus entschieden,
 * sondern ber einen Parameter beim Aufruf
 * 
 * 2) addSplit kann auch direkt ins Log schreiben, gesteuert von
 * einem Parameter beim Initialisieren
 * 
 * @author Jockel
 *
 */
public class TimingLogger2 {
	private boolean mDebug; // Arbeiten durchfhren
	private boolean mInstant; // addSplit schreibt sofort
	private String mTag; // TAG fr Logdatei
	private String mTitle; // Titel
	private long mFirst, mLast; // currenttime-Speicher
	private ArrayList<String> mBuffer = null; // falls nicht instant
	
	
	public TimingLogger2(boolean aDebug, String aTag, String aTitle, boolean aInstant) {
		if (mDebug = aDebug) reset(aTag, aTitle, aInstant);
	}
	
	
	public TimingLogger2( String aTag, String aTitle, boolean aInstant) {
		mDebug = true;
		reset(aTag, aTitle, aInstant);
	}

	
	public TimingLogger2( String aTag, String aTitle) {
		mDebug = true;
		reset(aTag, aTitle, false);
	}

	
	public void reset(String aTag, String aTitle, boolean aInstant) {
		mTag = aTag;
		mTitle = aTitle;
		mInstant = aInstant;
		reset();
	}
	
	
	public void reset() {
		mFirst = mLast = System.currentTimeMillis();
		if (!mInstant) mBuffer = new ArrayList<String>(10);
		line(mTitle+": begin");
	}
	
	
	public void addSplit(String mWork) {
		if (!mDebug) return;
		long now = System.currentTimeMillis();
		line(mTitle + ":      " + (now-mLast) +" ms, "+mWork);
		mLast = now;
	}
	
	
	public void dumpToLog() {
		if (!mDebug) return;
		line(mTitle + ": end, "+(System.currentTimeMillis()-mFirst)+" ms");
		if (!mInstant)	
			for (String l : mBuffer) Log.v(mTag, l);
	}
	
	
	private void line(String aLine) {
		if (mInstant)
			Log.v(mTag, aLine);
		else
			mBuffer.add(aLine);
	}
}
