#include <Mechanic.h>

ObdInterface obd;
ObdMessage msg;

void setup() {
  Serial.begin(115200);
  while (!Serial);

  obd.setSlow(false);
  obd.setExtended(false);
  obd.setDebug(false);
  obd.begin();

  Serial.println();
  Serial.println();
  Serial.println("   | 0 1 2 3 4 5 6 7 8 9 A B C D E F");
  Serial.println("---+--------------------------------");
  
  for (int i = 0; i <= 0xf0; i += 0x10) {
    Serial.print(i, HEX);
    Serial.print(i == 0 ? "0 |" : " |");
    for (int j = 0; j <= 0x0f; j++) {
      boolean supported;
      if (obd.isPidSupported(i + j, supported)) {
        Serial.print(supported ? " X" : "  ");
      } else {
        Serial.print(" ?");
      }
      
      delay(50);
    }
    Serial.println();
  }
}

void loop() {
}

