#!/bin/bash

# c't Hardware Hacks - Spracherkennung für den Raspberry Pi, GPL-Lizenz

count=1
lastsize=0
rec=0
first=1

# Der Soundchip des RPI erzeugt vor und nach der Wiedergabe ein Knacken. Deutlich bessere Ergebnisse liefert eine USB-Soundkarte, wie man sie bereits für rund fünf Euro bekommt. Damit mplayer die USB-Soundkarte benutzt, ändert man den Parameter "-ao alsa:device=hw=0.0" in "-ao alsa:device=hw=1.0".

function say {
mplayer -ao alsa:device=hw=0.0 -really-quiet -http-header-fields "User-Agent:Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.22 (KHTML, like Gecko) Chrome/25.0.1364.172 Safari/537.22m" "http://translate.google.com/translate_tts?tl=de&q=$1";
} 

sox -t alsa hw:1,0 test.wav silence 1 0 0.5% -1 1.0 1% &
sox_pid=$!

while [ $count -le 9 ]
do
   
size=$(stat --printf="%s" test.wav)

if [ $size -gt $lastsize ]
	then
		if [ $first -eq 0 ]
		then
			echo "Aufnahme!"
			rec=1
		else
			first=0
		fi
	else
		if [ $rec -eq 1 ]
			then
				echo "Abschicken"
				kill $sox_pid
				ffmpeg -loglevel panic -y -i test.wav -ar 16000 -acodec flac file.flac
				wget -q -U "Mozilla/5.0" --post-file file.flac --header "Content-Type: audio/x-flac; rate=16000" -O - "http://www.google.com/speech-api/v1/recognize?lang=de-de&client=chromium" | cut -d\" -f12 >stt.txt
				cat stt.txt
				say "$(cat stt.txt)"

				if [[ $(cat stt.txt) =~ "Befehl" ]]
				then
					echo "Sprachbefehl erkannt!"
 					say "Sprachbefehl erkannt! Ich könnte jetzt einen beliebigen Shell-Befehl ausführen!"
					# mach was
				elif [[ $(cat stt.txt) =~ "Wetterbericht" ]]
				then
					echo "Wetterbericht erkannt!"
 					say "Ich würde Dir jetzt den Wetterbericht vorlesen! Bring es mir bei!"
					# mach was
				else
 					echo "Kein Kommando erkannt..."
				fi

			sleep 1
			bash ctvoice.sh
		else
			echo "Stille..."
		fi
		rec=0
fi

lastsize=$size

sleep 1

done
