#define Ausloeser 7
#define Vorausloeser 12
#define Led 13
#define Lichtschranke A0
#define Blitzladezeit 5000  //5 Sekunden Blizladezeit

int schwelle = 100; // Schwellenwert für die Lichtschranke hier festlegen
int verzoegerung =120; // Auslöseverzögerung in ms festlegen 120

void setup() {
  pinMode(Led, OUTPUT);
  pinMode(Ausloeser, OUTPUT);
  pinMode(Vorausloeser, OUTPUT);
  digitalWrite(Ausloeser, LOW);
  digitalWrite(Vorausloeser, HIGH);// Vorauslöser betätigen (Blitz laden)   
  Serial.begin(9600);
  digitalWrite(Vorausloeser, HIGH); // Vorauslöser betätigen (Blitz laden)
  delay(Blitzladezeit);
  digitalWrite(Led, HIGH); //  auch die LED wieder anschalten ( Anlage scharf)
}

void loop() {
  int sensorValue = analogRead(Lichtschranke);
  Serial.println(sensorValue, DEC); // Daten der Lichtschranke auf dem Computer ausgeben => darüber Schwellenwert festlegen
  if (sensorValue < schwelle)
   { 
     delay(verzoegerung); // Kameraauslösung verzögern
     digitalWrite(Ausloeser, HIGH); // Kameraauslöser betätigen
     digitalWrite(Led, LOW); // LED ausschalten zur Bestätigung, dass die Kamera ausgelöst hat
     delay(500); // Kameraauslöser loslassen verzögern
     digitalWrite(Ausloeser, LOW); // Kameraauslöser wieder loslassen
     digitalWrite(Vorausloeser, LOW); // Vorauslöser loslassen
     delay(500);
     digitalWrite(Vorausloeser, HIGH); // Vorauslöser betätigen (Blitz laden)    
     delay(Blitzladezeit); // 3 Sekunden warten, bevor der Trigger wieder "scharf" ist
     digitalWrite(Led, HIGH); //  auch die LED wieder anschalten ( Anlage scharf)
   }
}
