/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.inputs;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoppyMIDIInput
implements Transmitter,
Receiver {
    MidiDevice currentDevice = null;
    Receiver downstreamReceiver = null;

    public void setDevice(MidiDevice.Info deviceInfo) throws MidiUnavailableException {
        if (this.currentDevice != null) {
            this.currentDevice.close();
        }
        this.currentDevice = MidiSystem.getMidiDevice(deviceInfo);
        this.currentDevice.open();
        this.currentDevice.getTransmitter().setReceiver(this);
    }

    @Override
    public void setReceiver(Receiver receiver) {
        this.downstreamReceiver = receiver;
    }

    @Override
    public Receiver getReceiver() {
        return this.downstreamReceiver;
    }

    @Override
    public void close() {
        if (this.currentDevice != null) {
            this.currentDevice.close();
            this.currentDevice = null;
        }
        if (this.downstreamReceiver != null) {
            this.downstreamReceiver.close();
            this.downstreamReceiver = null;
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (this.downstreamReceiver != null) {
            this.downstreamReceiver.send(message, timeStamp);
        }
    }

    public static HashMap<String, MidiDevice.Info> getMIDIInInfos() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        HashMap<String, MidiDevice.Info> outInfos = new HashMap<String, MidiDevice.Info>();
        for (MidiDevice.Info i : infos) {
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(i);
                if (dev.getMaxTransmitters() == 0) continue;
                outInfos.put(i.getName(), i);
            }
            catch (MidiUnavailableException ex) {
                Logger.getLogger(MoppyMIDIInput.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return outInfos;
    }
}

