/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.Transmitter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import moppydesk.MoppyStatusConsumer;
import moppydesk.MoppyUI;
import moppydesk.inputs.MoppySequencer;
import moppydesk.ui.InputPanel;
import moppydesk.ui.MoppyControlWindow;

public class SequencerControls
extends InputPanel
implements MoppyStatusConsumer {
    MoppySequencer seq;
    MoppyControlWindow controlWindow;
    MoppyUI app;
    final JFileChooser sequenceChooser = new JFileChooser();
    Timer progressTimer;
    private boolean isConnected = false;
    private boolean fileLoaded = false;
    private JLabel bpmLabel;
    private JLabel currentPositionLabel;
    private JLabel jLabel1;
    private JSlider jSlider1;
    private JButton loadButton;
    private JLabel sequenceNameLabel;
    private JSlider sequenceProgressSlider;
    private JButton startButton;
    private JButton stopButton;
    private JLabel totalPositionLabel;

    public SequencerControls(MoppyUI app, MoppyControlWindow mcw, MoppySequencer newSequencer) {
        this.seq = newSequencer;
        this.app = app;
        this.controlWindow = mcw;
        this.initComponents();
        this.progressTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequencerControls.this.updateProgressDisplay();
            }
        });
    }

    private void updateProgressDisplay() {
        long currentSeconds = this.seq.getSecondsPosition();
        this.sequenceProgressSlider.setValue((int)currentSeconds);
        String currentPosition = String.format("%d:%02d", TimeUnit.SECONDS.toMinutes(currentSeconds), currentSeconds % 60L);
        String totalPosition = String.format("%d:%02d", TimeUnit.SECONDS.toMinutes(this.seq.getSecondsLength()), this.seq.getSecondsLength() % 60L);
        this.currentPositionLabel.setText(currentPosition);
        this.totalPositionLabel.setText(totalPosition);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.sequenceNameLabel = new JLabel();
        this.bpmLabel = new JLabel();
        this.jSlider1 = new JSlider();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.loadButton = new JButton();
        this.sequenceProgressSlider = new JSlider();
        this.currentPositionLabel = new JLabel();
        this.totalPositionLabel = new JLabel();
        this.jLabel1.setText("Current Sequence:");
        this.sequenceNameLabel.setText("<None loaded>");
        this.bpmLabel.setText(this.jSlider1.getValue() + " bpm");
        this.jSlider1.setMajorTickSpacing(10);
        this.jSlider1.setMaximum(310);
        this.jSlider1.setMinimum(20);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setValue(120);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                SequencerControls.this.jSlider1tempoSliderChanged(evt);
            }
        });
        this.startButton.setText("Start");
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencerControls.this.startButtonClicked(evt);
            }
        });
        this.stopButton.setText("Stop/Reset");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencerControls.this.stopButtonstopResetClicked(evt);
            }
        });
        this.loadButton.setText("Load Sequence");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SequencerControls.this.loadButtonloadSequence(evt);
            }
        });
        this.sequenceProgressSlider.setToolTipText("");
        this.sequenceProgressSlider.setValue(0);
        this.sequenceProgressSlider.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SequencerControls.this.sequenceProgressDragged(evt);
            }
        });
        this.sequenceProgressSlider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                SequencerControls.this.sequenceProgressDragged(evt);
            }
        });
        this.currentPositionLabel.setText("00:00");
        this.totalPositionLabel.setText("00:00");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sequenceNameLabel).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.loadButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(126, 126, 126).addComponent(this.bpmLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jSlider1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.startButton, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.currentPositionLabel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sequenceProgressSlider, -2, 376, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.totalPositionLabel, -2, 30, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sequenceNameLabel)).addComponent(this.loadButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.bpmLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSlider1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopButton).addComponent(this.startButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sequenceProgressSlider, -1, -1, Short.MAX_VALUE).addComponent(this.currentPositionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.totalPositionLabel, -1, -1, Short.MAX_VALUE))));
    }

    private void jSlider1tempoSliderChanged(MouseEvent evt) {
        JSlider s = (JSlider)evt.getSource();
        this.seq.setTempo(s.getValue());
        this.bpmLabel.setText(s.getValue() + " bpm");
    }

    private void startButtonClicked(ActionEvent evt) {
        if (this.startButton.getText().equals("Start")) {
            this.playSequencer();
        } else {
            this.pauseSequencer();
        }
    }

    private void playSequencer() {
        this.seq.startSequencer();
        this.seq.setTempo(this.jSlider1.getValue());
        this.controlWindow.setStatus("Playing!");
        this.startButton.setText("Pause");
    }

    private void pauseSequencer() {
        this.seq.stopSequencer();
        this.startButton.setText("Start");
        this.controlWindow.setStatus("...Paused");
    }

    private void stopResetSequencer() {
        if (this.seq.isRunning()) {
            this.controlWindow.setStatus("Stopping...");
            this.seq.stopSequencer();
            this.seq.resetSequencer();
            this.startButton.setText("Start");
            this.controlWindow.setStatus("Stopped.");
        } else {
            this.app.rm.reset();
            this.controlWindow.setStatus("Reset.");
        }
    }

    private void stopButtonstopResetClicked(ActionEvent evt) {
        this.stopResetSequencer();
    }

    private void loadButtonloadSequence(ActionEvent evt) {
        int returnVal;
        String previouslyLoaded = this.app.prefs.get("loadedSequencePath", null);
        if (previouslyLoaded != null) {
            this.sequenceChooser.setCurrentDirectory(new File(previouslyLoaded));
        }
        if ((returnVal = this.sequenceChooser.showOpenDialog(this)) == 0) {
            this.loadSequenceFile(this.sequenceChooser.getSelectedFile());
        }
    }

    private void sequenceProgressDragged(MouseEvent evt) {
        int seconds = ((JSlider)evt.getSource()).getValue();
        this.seq.setSecondsPosition(seconds);
        this.currentPositionLabel.setText(String.format("%d:%02d", TimeUnit.SECONDS.toMinutes(seconds), seconds % 60));
    }

    public void tempoChanged(int newTempo) {
        this.jSlider1.setValue(newTempo);
        this.bpmLabel.setText(newTempo + " bpm");
    }

    private void loadSequenceFile(File sequenceFile) {
        try {
            this.controlWindow.setStatus("Loading file...");
            this.seq.loadFile(sequenceFile.getPath());
            this.sequenceNameLabel.setText(sequenceFile.getName());
            this.sequenceProgressSlider.setMaximum((int)this.seq.getSecondsLength());
            this.app.prefs.put("loadedSequencePath", sequenceFile.getPath());
            this.fileLoaded = true;
            this.controlWindow.setStatus("Loaded " + sequenceFile.getName());
            this.updateProgressDisplay();
            if (this.isConnected) {
                this.startButton.setEnabled(true);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MoppyControlWindow.class.getName()).log(Level.SEVERE, null, ex);
            this.controlWindow.setStatus("File loading error!");
            JOptionPane.showMessageDialog(this.getRootPane(), ex);
        }
    }

    public Transmitter getTransmitter() {
        return this.seq;
    }

    public void connected() {
        this.progressTimer.start();
        this.isConnected = true;
        if (this.fileLoaded) {
            this.startButton.setEnabled(true);
        }
    }

    public void disconnected() {
        this.startButton.setEnabled(false);
        this.pauseSequencer();
        this.isConnected = false;
        this.progressTimer.stop();
        this.seq.setReceiver(null);
    }
}

