/*
 * Decompiled with CFR 0.152.
 */
package moppydesk.outputs;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import moppydesk.outputs.MoppyReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoppyMIDIOutput
implements MoppyReceiver {
    MidiDevice device;
    Receiver deviceReceiver;

    public MoppyMIDIOutput(String midiDeviceName) throws MidiUnavailableException {
        MidiDevice.Info[] infos;
        for (MidiDevice.Info i : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                if (!i.getName().equalsIgnoreCase(midiDeviceName)) continue;
                this.device = MidiSystem.getMidiDevice(i);
            }
            catch (MidiUnavailableException ex) {
                Logger.getLogger(MoppyMIDIOutput.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.device.open();
        this.deviceReceiver = this.device.getReceiver();
    }

    public static HashMap<String, MidiDevice.Info> getMIDIOutInfos() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        HashMap<String, MidiDevice.Info> outInfos = new HashMap<String, MidiDevice.Info>();
        for (MidiDevice.Info i : infos) {
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(i);
                if (dev.getMaxReceivers() == 0) continue;
                outInfos.put(i.getName(), i);
            }
            catch (MidiUnavailableException ex) {
                Logger.getLogger(MoppyMIDIOutput.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return outInfos;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.deviceReceiver.send(message, timeStamp);
    }

    @Override
    public void close() {
        this.deviceReceiver.close();
        this.device.close();
    }

    @Override
    public void reset() {
        if (this.deviceReceiver != null) {
            try {
                ShortMessage resetMessage = new ShortMessage();
                resetMessage.setMessage(255);
                this.deviceReceiver.send(resetMessage, -1L);
            }
            catch (InvalidMidiDataException ex) {
                Logger.getLogger(MoppyMIDIOutput.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

