const int BAUD_RATE = 9600;
const int LED_PIN = 13;
const int DEF_CMD_LEN = 20;

String command = "";
boolean receivedCommand = false;

void setup() {
  Serial.begin(BAUD_RATE);
  pinMode(LED_PIN, OUTPUT);
  command.reserve(DEF_CMD_LEN);
}

void loop() {
  if (receivedCommand) {
    if (command == "on") {
      digitalWrite(LED_PIN, HIGH);
      Serial.println("LED is on.");
    } else if (command == "off") {
      digitalWrite(LED_PIN, LOW);
      Serial.println("LED is off.");
    }
    command = "";
    receivedCommand = false;
  }
}

void serialEvent() {
  while (Serial.available()) {
    char c = (char)Serial.read(); 
    if (c == '\n') {
      receivedCommand = true;
    } else {
      command += c;
    } 
  }
}
