#define SCLK 2
#define SDIO 3



#define REG_CONFIGURATION 0x00
#define REG_REVISION_ID 0x01
#define REG_DELTA_X 0x02
#define REG_DELTA_Y 0x03
#define REG_SQUAL 0x04
#define REG_MAXIMUM_PIXEL 0x05
#define REG_MINIMUM_PIXEL 0x05
#define REG_PIXEL_SUM 0x07
#define REG_PIXEL_DATA 0x08
#define REG_SHUTTER_UPPER 0x09
#define REG_SHUTTER_LOWER 0




byte frame[324];
byte i;
byte camWidth = 18;
byte camHeight = 18;
const byte maskNoSleep  = 0x01;
const byte maskPID      = 0xE0;


void setup()
{
  pinMode(SCLK, OUTPUT);
  pinMode(SDIO, OUTPUT); 

    
  Serial.begin(38400);
  Serial.flush();

 
  byte config = readRegister(REG_CONFIGURATION); 
  config |= B00000001; // // Maus immer an, LED immer an
  writeRegister(REG_CONFIGURATION, config);
     
}


void loop() {
   int input;

  if( Serial.available() )
  {
    input = Serial.read();
    switch( input )
    {
    case 'c':
      coordinates();
      break;
    case 'd':
      getFrame(frame);
      break;
    }
  }
  
}


void getFrame(byte* pixel)
{
  
  writeRegister(REG_PIXEL_DATA, 0xAA); //irgendwas in das Register schreiben, um das Senden zu starten

  delayMicroseconds(500);
  int count = 0;
  
  do {
    byte data = readRegister(REG_PIXEL_DATA);
      frame[count++] = ((data & B00111111)); 
      delayMicroseconds(500);
     } 
  while (count != 324);

  
  for(int i = 0; i < camHeight; i++) {
    for(int j = 0; j < camWidth; j++) {

        byte pix = (frame[(i*18) + j]); 

      Serial.write(pix);

    }  

  }

  
}



byte readRegister(byte address) {
  pinMode (SDIO, OUTPUT);

  for (byte i=128; i >0 ; i >>= 1) {
    digitalWrite (SCLK, LOW);
    digitalWrite (SDIO, (address & i) != 0 ? HIGH : LOW);
    digitalWrite (SCLK, HIGH);
  }

  pinMode (SDIO, INPUT);

  delayMicroseconds(1); // tHOLD = 100us min.

  byte res = 0;
  for (byte i=128; i >0 ; i >>= 1) {
    digitalWrite (SCLK, LOW);
    digitalWrite (SCLK, HIGH);
    if( digitalRead (SDIO) == HIGH )
      res |= i;
  }

  return res;
}


void writeRegister(byte address, byte data) {
  address |= 0x80; 
  pinMode (SDIO, OUTPUT);

  for (byte i = 128; i > 0 ; i >>= 1) {
    digitalWrite (SCLK, LOW);
    digitalWrite (SDIO, (address & i) != 0 ? HIGH : LOW);
    digitalWrite (SCLK, HIGH);
  }

  for (byte i = 128; i > 0 ; i >>= 1) {
    digitalWrite (SCLK, LOW);
    digitalWrite (SDIO, (data & i) != 0 ? HIGH : LOW);
    digitalWrite (SCLK, HIGH);
  }

  delayMicroseconds(100); // tSWW, tSWR = 100us min.
}


void coordinates()
{
  char dx = readRegister(REG_DELTA_X);
  char dy = readRegister(REG_DELTA_Y);
  Serial.println("DELTA: "); 
  Serial.println(dx, DEC);
  Serial.println(dy, DEC);
}
