#Fotoautomat mit Raspberry Pi
#Make 1/15
#

import RPi.GPIO as IO
import time
import picamera
from flickrapi import FlickrAPI
from os.path import basename, splitext
import sys
import getopt

import PIL.Image
import PIL.ImageEnhance
from PIL import Image



fuser='hier bitte eigene Dateneintragen'
key='hier bitte eigene Dateneintragen'
secret='hier bitte eigene Dateneintragen'



def shot():
   Zeit= time.ctime(time.time())
   Zeit= Zeit.replace(" ", "_")
   Zeit= Zeit.replace(":", "")
   Datei="./party" + Zeit+ ".jpg"
   
   for i in range (0 ,5):
      PiCam.led = False
      time.sleep (0.2)
      PiCam.led = True
      time.sleep (0.2)

   print "Aufnahme"
   PiCam.capture(Datei)
   bild = PIL.Image.open(Datei)
   logo = PIL.Image.open('./logo.png')
   logo = logo.resize((173, 71), Image.ANTIALIAS)
   brightness = 0.8
   logo = PIL.ImageEnhance.Brightness(logo).enhance(brightness)
   pos = (10,680)
   bild.paste(logo, pos)
   bild.save(Datei)
   t = splitext(basename(Datei))[0]   
   
   PiCam.stop_preview()
   PiCam.preview_fullscreen= False
   PiCam.start_preview()
   print "Auf Flicker hochladen..."
   response=flickr.upload(filename=Datei, title=t, is_public=1, format='etree')
   photoID = response.find('photoid').text
   photoURL = 'http://www.flickr.com/photos/%s/%s/' % (fuser, photoID)
   print "Fertig"
   time.sleep(1)


flickr = FlickrAPI(key, secret)
(token, frob) = flickr.get_token_part_one(perms='write')

if not token:
    raw_input("Bitte Anwendung im Browser autorisieren und dann ENTER druecken")
flickr.get_token_part_two((token, frob))

PiCam = picamera.PiCamera()
PiCam.preview_fullscreen= False
PiCam.resolution=(1024, 768)
PiCam.preview_window = (1, 1 , 800, 600)
PiCam.start_preview()

IO.setwarnings(False)
IO.setmode(IO.BCM)
Taster = 23
IO.setup(Taster, IO.IN, pull_up_down=IO.PUD_DOWN)
finished = False

while not finished:
   if(IO.input(Taster)):
     print "Starte Fullscreen-Vorschau"
     PiCam.stop_preview() 
     PiCam.preview_fullscreen= True
     PiCam.start_preview()
     time.sleep(1)
     
     while not IO.input(Taster):
        pass
     shot()
     print "Bitte Taster fuer grosse Vorschau druecken"

