require 'RMagick'
include Magick

image_name = File.basename(ARGV[0], File.extname(ARGV[0]))
puts "const unsigned char #{image_name}[] PROGMEM = {"

Image::read(ARGV[0]).each do |image|
  (0...image.rows).each do |y|
    print '  B'
    (0...image.columns).each do |x|
      pixel = image.pixel_color(x, y)
      is_black = (pixel.red == 0) and (pixel.green == 0) and (pixel.blue == 0)
      print is_black ? '1' : '0'
      print ', B' if (x + 1) % 8 == 0
    end
    print '0' * (8 - (image.columns % 8))
    puts ','
  end
  puts
end

puts '};'
