//Parametric tube clamp
/*
Parameters:
    in_dia: Diameter of tube (10)
    thickn: Wall thickness of clamp ring (5)
    width: Width of clamp (12)
    scrw_dia: Diameter of screw (3.5)
    scrw_hd_dia: Diameter of screw head (7)
    fac: Number of facettes on cylinders
*/

translate([-20, -28, 0]) tub_cl();
translate([-20, -14, 0]) tub_cl();

module tub_cl(
    in_dia = 10,
    thickn = 4,
    width = 12,
    scrw_dia = 3.5,
    scrw_hd_dia = 7,
    fac = 128)
{ //module begin

    //tub_cl
       
    difference() {
        union() {              
           
            //Add ring
            rotate([90, 0, 0])
            translate([0, -1, 0])
            cylinder(d=in_dia+2*thickn, h=width, center=false, $fn=fac);
           
            //Add side extensions   
            //translate([-15, -28, 0])
            translate([in_dia/2, -width, 0])
            cube([12, width, thickn], center=false);
            translate([-in_dia/2-12, -width, 0])
            cube([12, width, thickn], center=false);
           
            //Add screw thread cylinder
            translate([in_dia/2+thickn+3.5, -width/2, 0])
            cylinder(d=8, h=8, center=false, $fn=fac);
           
            //Add screw thread dome
            translate([in_dia/2+thickn+3.5, -width/2, 8])
            cylinder(d1=8, d2=4, h=3, center=false, $fn=fac);
           
        } //union end
        ;
       
        //Subtract cylinder for tube
            rotate([90, 0, 0])
            translate([0, -1, 2])
            cylinder(d=in_dia, h=2*width, center=true, $fn=fac);
       
        //Subtract lower half
            translate([0, 0, -100])
            cube([500, 500, 200], center=true);
       
        //Subtract vertical bolt holes
            translate([-in_dia/2-thickn-3.5, -width/2, 0])
            cylinder(d=scrw_dia, h=20, center=true, $fn=fac);
       
            translate([in_dia/2+thickn+3.5, -width/2, 0])
            cylinder(d=scrw_dia*0.7, h=18, center=true, $fn=fac);
             
        //Subtract countersunk cones
            translate([-in_dia/2-thickn-3.5, -width/2, thickn-1.74])
            cylinder(d1=0, d2=scrw_hd_dia, h=3.5, center=true, $fn=fac);
  
         } //difference end 
     }     //module end