// total display size
#define H 20
#define W 15

#define FPS      60    // 60Hz

#define GAME_CYCLE (1000/FPS)

#define NUM_LEDS (W*H)

#define TITLE_SCROLL_SPEED      2
#define GAME_SCORE_SCROLL_SPEED 5   // frames@60Hz

// pin mapping
#define KEY_DROP_PIN     7    // should be connected to "up"
#define KEY_DOWN_PIN     8
#define KEY_LEFT_PIN     5    // was 9
#define KEY_RIGHT_PIN    6    // was 10         
#define KEY_ROTATE_PIN  11    // should be connected to "fire"

#define DATA_PIN        12

#define SPEAKER_PIN      9
#define SPEAKER_PIN_2   10   // second channel option

#define LED_PIN         13   // arduino on board led

#define NO_DROP              // use drop key as second rotate

#define KEY_LEFT    0x01
#define KEY_RIGHT   0x02
#define KEY_ROTATE  0x04
#define KEY_DOWN    0x08
#define KEY_DROP    0x10
#define KEY_PAUSE   0x20    // generated from key combo
