$fn=100;

print_plate();

//3d_view();

module 3d_view(){
        rotate([-90,0,0]) servo_mount();
        translate([30,-8,15]) rotate([270,-20,0]) servo_coupler();
        translate([80,15,15]) rotate([180,0,-90]) notch();
         translate([4,15,0]) rotate([0,0,180]) notch_mount();
}

module print_plate(){
        translate([0,0,3]) servo_mount();
        translate([-5,15,3]) servo_coupler();
        translate([-5,-25,0])  rotate([0,0,90]) notch();
        translate([78,-15,10.5]) notch_mount();
}
  
module servo_mount(){
    rotate([90,0,0]){

    difference(){
      translate([-15,-3,0]) cube([60.5,23,3.5]);
      translate([5,12,1]) cylinder(8,1.7,1.7,true);
      translate([20,12,1]) cylinder(8,1.7,1.7,true);
      
      // sonic sensor mount
      translate([-18,8.5,3]) cylinder(10,8.5,8.5,true);
      translate([-9,0,1]) cylinder(8,1.2,1.2,true);
      translate([-9,17,1]) cylinder(8,1.2,1.2,true);
    }


    difference(){
      translate([0,0,0]) rotate([90,0,0]) cube([45.5,16.8,3]);
      translate([12,0,0]){
      translate([4.5,-4,5]) cube([23.6,10,12]);
      translate([2.5,0,11]) rotate([90,0,0]) cylinder(8,1.3,1.4,true);
      translate([30.5,0,11]) rotate([90,0,0]) cylinder(8,1.3,1.4,true);
    }

    }
    }

    translate([39.5,0,-3]) cube([6,5,23]);
    translate([-7,0,-3]) cube([6,5,23]);    
    
}
  
  
module servo_coupler(){
    difference(){
        hull(){
         cylinder(6,12.15/2,12.15/2,true);
         translate([45.5,0,0]) cylinder(6,8.13/2,8.13/2,true);
        } 

        cylinder(10,1.2,1.2,true);
        translate([0,0,-9]) cylinder(15,3,3,true);

        translate([0,0,2]){
           hull(){
           cylinder(3,7.45/2,7.45/2,true);
           translate([18.5,0,0]) cylinder(3,4.43/2,4.43/2,true);
          } 
         }
        translate([40,0,0]) cylinder(10,1.8,1.8,true);
      }
}
  
  
module notch(){
      
b = 5;
h = 3;
w = 5;


    //Start with an extruded triangle
    translate([-1,-29,2.5]){
     rotate(a=[0,0,0])
      linear_extrude(height = w, center = true, convexity = 10, twist = 0)
       polygon(points=[[0,0],[h,0],[0,b]], paths=[[0,1,2]]);
    }
    rotate([90,0,0]){
      _notch(40);
}

translate([-16.5,1,0])  cube([12,3,5]);

module _notch(height){
translate([-5,0,0]) cube([5,5,height]);
  difference(){
   translate([-2.5,5,-1.6]) rotate([90,90,0]) cylinder(5,5,5);
   translate([-2.5,5.3,-1.5]) rotate([90,90,0]) cylinder(5.5,1.7,1.7);
  }
}     
 }
  
  module notch_mount(){
  // Notch mount
  difference(){
    union(){
      translate([-57,-6,-10.5]) cube([16,14,10]);
     translate([-57,8,-2]) rotate([90,0,0]) cube([12,5,14]);
      //%translate([-52,8,-2]) rotate([90,0,0]) cylinder(14,5,5);
    }
    translate([-57.1,-2,-7]) cube([13.2,6,14]);
    translate([-52,11,-1]) rotate([90,0,0]) cylinder(20,1.7,1.7);
    translate([-45,1,-4])rotate([0,90,0]) cylinder(10,1.6,1.6,true);
  }
 }

