/*
 *	Font
 *	Horizontal angeordnet, Low Bit First, Quelle: Benedikt K., http://www.mikrocontroller.net/topic/54860
 *	weitere Fonts: https://github.com/dhepper/font8x8
 *
 *	Modifiziert VI/2016 von Florian Schffer fr ISO 8859-1: Deutsche Umlaute
 */

#include <avr/pgmspace.h>   // PROGMEM um Variable im Flash abzulegen. https://www.arduino.cc/en/Reference/PROGMEM

const uint8_t font[256][8] PROGMEM = {
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x00
{0x70,0x88,0xD8,0x88,0xA8,0x88,0x70,0x00},	// 0x01
{0x70,0xF8,0xA8,0xF8,0x88,0xF8,0x70,0x00},	// 0x02
{0x00,0x50,0xF8,0xF8,0xF8,0x70,0x20,0x00},	// 0x03
{0x00,0x20,0x70,0xF8,0xF8,0x70,0x20,0x00},	// 0x04
{0x20,0x70,0x70,0x20,0xF8,0xF8,0x20,0x00},	// 0x05
{0x00,0x20,0x70,0xF8,0xF8,0x20,0x70,0x00},	// 0x06
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x07
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x08
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x09
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x0A
{0x00,0xE0,0xC0,0xB0,0x48,0x48,0x30,0x00},	// 0x0B
{0x70,0x88,0x88,0x70,0x20,0x70,0x20,0x00},	// 0x0C
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x0D
{0xC0,0xB0,0xD0,0xB0,0xD0,0xD8,0x18,0x00},	// 0x0E
{0x00,0xA8,0x70,0xD8,0x70,0xA8,0x00,0x00},	// 0x0F
{0x10,0x30,0x70,0xF0,0x70,0x30,0x10,0x00},	// 0x10
{0x40,0x60,0x70,0x78,0x70,0x60,0x40,0x00},	// 0x11
{0x20,0x70,0xF8,0x20,0xF8,0x70,0x20,0x00},	// 0x12
{0x50,0x50,0x50,0x50,0x50,0x00,0x50,0x00},	// 0x13
{0xF0,0xA8,0xA8,0xB0,0xA0,0xA0,0xA0,0x00},	// 0x14
{0x70,0x88,0x30,0x50,0x60,0x88,0x70,0x00},	// 0x15
{0x00,0x00,0x00,0x00,0x00,0x78,0x78,0x00},	// 0x16
{0x20,0x70,0xF8,0x20,0xF8,0x70,0x20,0x70},	// 0x17
{0x20,0x70,0xF8,0x20,0x20,0x20,0x20,0x00},	// 0x18
{0x20,0x20,0x20,0x20,0xF8,0x70,0x20,0x00},	// 0x19
{0x00,0x20,0x60,0xF8,0x60,0x20,0x00,0x00},	// 0x1A
{0x00,0x20,0x30,0xF8,0x30,0x20,0x00,0x00},	// 0x1B
{0x00,0x00,0x00,0x08,0x08,0x08,0xF8,0x00},	// 0x1C
{0x00,0x50,0x50,0xF8,0x50,0x50,0x00,0x00},	// 0x1D
{0x20,0x20,0x70,0x70,0xF8,0xF8,0x00,0x00},	// 0x1E
{0xF8,0xF8,0x70,0x70,0x20,0x20,0x00,0x00},	// 0x1F
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x20 space
{0x20,0x70,0x70,0x20,0x20,0x00,0x20,0x00},	// 0x21 !
{0xD8,0xD8,0x48,0x00,0x00,0x00,0x00,0x00},	// 0x22
{0x00,0x50,0xF8,0x50,0x50,0xF8,0x50,0x00},	// 0x23
{0x10,0x70,0x08,0x30,0x40,0x38,0x20,0x00},	// 0x24
{0x98,0x98,0x40,0x20,0x10,0xC8,0xC8,0x00},	// 0x25
{0x10,0x28,0x28,0x10,0xA8,0x48,0xB0,0x00},	// 0x26
{0x30,0x30,0x10,0x00,0x00,0x00,0x00,0x00},	// 0x27
{0x20,0x10,0x10,0x10,0x10,0x10,0x20,0x00},	// 0x28
{0x10,0x20,0x20,0x20,0x20,0x20,0x10,0x00},	// 0x29
{0x00,0x50,0x70,0xF8,0x70,0x50,0x00,0x00},	// 0x2A
{0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0x00},	// 0x2B
{0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x10},	// 0x2C
{0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00},	// 0x2D
{0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00},	// 0x2E
{0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00},	// 0x2F
{0x70,0x88,0xC8,0xA8,0x98,0x88,0x70,0x00},	// 0x30
{0x20,0x30,0x20,0x20,0x20,0x20,0x70,0x00},	// 0x31
{0x70,0x88,0x80,0x60,0x10,0x08,0xF8,0x00},	// 0x32
{0x70,0x88,0x80,0x70,0x80,0x88,0x70,0x00},	// 0x33
{0x40,0x60,0x50,0x48,0xF8,0x40,0x40,0x00},	// 0x34
{0xF8,0x08,0x08,0x78,0x80,0x88,0x70,0x00},	// 0x35
{0x60,0x10,0x08,0x78,0x88,0x88,0x70,0x00},	// 0x36
{0xF8,0x80,0x40,0x20,0x10,0x10,0x10,0x00},	// 0x37
{0x70,0x88,0x88,0x70,0x88,0x88,0x70,0x00},	// 0x38
{0x70,0x88,0x88,0xF0,0x80,0x40,0x30,0x00},	// 0x39
{0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x00},	// 0x3A
{0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x10},	// 0x3B
{0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00},	// 0x3C
{0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00},	// 0x3D
{0x10,0x20,0x40,0x80,0x40,0x20,0x10,0x00},	// 0x3E
{0x70,0x88,0x80,0x60,0x20,0x00,0x20,0x00},	// 0x3F
{0x70,0x88,0xE8,0xA8,0xE8,0x08,0x70,0x00},	// 0x40
{0x70,0x88,0x88,0x88,0xF8,0x88,0x88,0x00},	// 0x41 A
{0x78,0x88,0x88,0x78,0x88,0x88,0x78,0x00},	// 0x42
{0x70,0x88,0x08,0x08,0x08,0x88,0x70,0x00},	// 0x43
{0x78,0x88,0x88,0x88,0x88,0x88,0x78,0x00},	// 0x44
{0xF8,0x08,0x08,0x78,0x08,0x08,0xF8,0x00},	// 0x45
{0xF8,0x08,0x08,0x78,0x08,0x08,0x08,0x00},	// 0x46
{0x70,0x88,0x08,0xE8,0x88,0x88,0xF0,0x00},	// 0x47
{0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00},	// 0x48
{0x70,0x20,0x20,0x20,0x20,0x20,0x70,0x00},	// 0x49
{0x80,0x80,0x80,0x80,0x88,0x88,0x70,0x00},	// 0x4A
{0x88,0x48,0x28,0x18,0x28,0x48,0x88,0x00},	// 0x4B
{0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x00},	// 0x4C
{0x88,0xD8,0xA8,0x88,0x88,0x88,0x88,0x00},	// 0x4D
{0x88,0x98,0xA8,0xC8,0x88,0x88,0x88,0x00},	// 0x4E
{0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00},	// 0x4F O
{0x78,0x88,0x88,0x78,0x08,0x08,0x08,0x00},	// 0x50
{0x70,0x88,0x88,0x88,0xA8,0x48,0xB0,0x00},	// 0x51
{0x78,0x88,0x88,0x78,0x48,0x88,0x88,0x00},	// 0x52
{0x70,0x88,0x08,0x70,0x80,0x88,0x70,0x00},	// 0x53
{0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0x00},	// 0x54
{0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00},	// 0x55 U
{0x88,0x88,0x88,0x88,0x88,0x50,0x20,0x00},	// 0x56
{0x88,0x88,0xA8,0xA8,0xA8,0xA8,0x50,0x00},	// 0x57
{0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00},	// 0x58
{0x88,0x88,0x88,0x50,0x20,0x20,0x20,0x00},	// 0x59
{0x78,0x40,0x20,0x10,0x08,0x08,0x78,0x00},	// 0x5A Z
{0x70,0x10,0x10,0x10,0x10,0x10,0x70,0x00},	// 0x5B
{0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00},	// 0x5C
{0x70,0x40,0x40,0x40,0x40,0x40,0x70,0x00},	// 0x5D
{0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00},	// 0x5E
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC},	// 0x5F
{0x30,0x30,0x20,0x00,0x00,0x00,0x00,0x00},	// 0x60
{0x00,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0x61 a
{0x08,0x08,0x78,0x88,0x88,0x88,0x78,0x00},	// 0x62
{0x00,0x00,0x70,0x88,0x08,0x88,0x70,0x00},	// 0x63
{0x80,0x80,0xF0,0x88,0x88,0x88,0xF0,0x00},	// 0x64
{0x00,0x00,0x70,0x88,0x78,0x08,0x70,0x00},	// 0x65
{0x60,0x10,0x10,0x78,0x10,0x10,0x10,0x00},	// 0x66
{0x00,0x00,0xF0,0x88,0x88,0xF0,0x80,0x70},	// 0x67
{0x08,0x08,0x38,0x48,0x48,0x48,0x48,0x00},	// 0x68
{0x20,0x00,0x20,0x20,0x20,0x20,0x60,0x00},	// 0x69
{0x40,0x00,0x60,0x40,0x40,0x40,0x48,0x30},	// 0x6A
{0x08,0x08,0x48,0x28,0x18,0x28,0x48,0x00},	// 0x6B
{0x20,0x20,0x20,0x20,0x20,0x20,0x60,0x00},	// 0x6C
{0x00,0x00,0x58,0xA8,0xA8,0x88,0x88,0x00},	// 0x6D
{0x00,0x00,0x38,0x48,0x48,0x48,0x48,0x00},	// 0x6E
{0x00,0x00,0x70,0x88,0x88,0x88,0x70,0x00},	// 0x6F o
{0x00,0x00,0x78,0x88,0x88,0x88,0x78,0x08},	// 0x70
{0x00,0x00,0xF0,0x88,0x88,0x88,0xF0,0x80},	// 0x71
{0x00,0x00,0x68,0x90,0x10,0x10,0x38,0x00},	// 0x72
{0x00,0x00,0x70,0x08,0x70,0x80,0x70,0x00},	// 0x73
{0x00,0x10,0x78,0x10,0x10,0x50,0x20,0x00},	// 0x74
{0x00,0x00,0x48,0x48,0x48,0x68,0x50,0x00},	// 0x75 u
{0x00,0x00,0x88,0x88,0x88,0x50,0x20,0x00},	// 0x76
{0x00,0x00,0x88,0x88,0xA8,0xF8,0x50,0x00},	// 0x77
{0x00,0x00,0x48,0x48,0x30,0x48,0x48,0x00},	// 0x78
{0x00,0x00,0x48,0x48,0x48,0x70,0x20,0x18},	// 0x79
{0x00,0x00,0x78,0x40,0x30,0x08,0x78,0x00},	// 0x7A z
{0x60,0x10,0x10,0x18,0x10,0x10,0x60,0x00},	// 0x7B
{0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00},	// 0x7C
{0x30,0x40,0x40,0xC0,0x40,0x40,0x30,0x00},	// 0x7D
{0x50,0x28,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x7E
{0x20,0x70,0xD8,0x88,0x88,0xF8,0x00,0x00},	// 0x7F
{0x70,0x88,0x08,0x08,0x88,0x70,0x20,0x30},	// 0x80
{0x48,0x00,0x48,0x48,0x48,0x68,0x50,0x00},	// 0x81
{0xC0,0x00,0x70,0x88,0x78,0x08,0x70,0x00},	// 0x82
{0x70,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0x83
{0x50,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0x84
{0x30,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0x85
{0x70,0x50,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0x86
{0x00,0x70,0x88,0x08,0x88,0x70,0x20,0x30},	// 0x87
{0x70,0x00,0x70,0x88,0x78,0x08,0x70,0x00},	// 0x88
{0x50,0x00,0x70,0x88,0x78,0x08,0x70,0x00},	// 0x89
{0x30,0x00,0x70,0x88,0x78,0x08,0x70,0x00},	// 0x8A
{0x50,0x00,0x20,0x20,0x20,0x20,0x60,0x00},	// 0x8B
{0x70,0x00,0x20,0x20,0x20,0x20,0x60,0x00},	// 0x8C
{0x10,0x00,0x20,0x20,0x20,0x20,0x60,0x00},	// 0x8D
{0x50,0x00,0x20,0x50,0x88,0xF8,0x88,0x00},	// 0x8E
{0x70,0x50,0x70,0xD8,0x88,0xF8,0x88,0x00},	// 0x8F
{0xC0,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00},	// 0x90
{0x00,0x00,0x78,0xA0,0xF8,0x28,0xF0,0x00},	// 0x91
{0xF0,0x28,0x28,0xF8,0x28,0x28,0xE8,0x00},	// 0x92
{0x70,0x00,0x30,0x48,0x48,0x48,0x30,0x00},	// 0x93
{0x50,0x00,0x30,0x48,0x48,0x48,0x30,0x00},	// 0x94
{0x18,0x00,0x30,0x48,0x48,0x48,0x30,0x00},	// 0x95
{0x70,0x00,0x48,0x48,0x48,0x68,0x50,0x00},	// 0x96
{0x18,0x00,0x48,0x48,0x48,0x68,0x50,0x00},	// 0x97
{0x50,0x00,0x48,0x48,0x48,0x70,0x20,0x18},	// 0x98
{0x48,0x30,0x48,0x48,0x48,0x48,0x30,0x00},	// 0x99
{0x50,0x00,0x48,0x48,0x48,0x48,0x30,0x00},	// 0x9A
{0x00,0x00,0x80,0x70,0x68,0x58,0x38,0x04},	// 0x9B
{0x60,0x90,0x10,0x78,0x10,0x90,0xE8,0x00},	// 0x9C
{0xF0,0xC8,0xA8,0xA8,0xA8,0x98,0x78,0x00},	// 0x9D
{0x00,0x88,0x50,0x20,0x50,0x88,0x00,0x00},	// 0x9E
{0x40,0xA0,0x20,0x70,0x20,0x20,0x28,0x10},	// 0x9F
{0x60,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0xA0
{0x60,0x00,0x20,0x20,0x20,0x20,0x60,0x00},	// 0xA1
{0x60,0x00,0x30,0x48,0x48,0x48,0x30,0x00},	// 0xA2
{0x60,0x00,0x48,0x48,0x48,0x68,0x50,0x00},	// 0xA3
{0x50,0x28,0x00,0x38,0x48,0x48,0x48,0x00},	// 0xA4
{0x50,0x28,0x00,0x48,0x58,0x68,0x48,0x00},	// 0xA5
{0x70,0x80,0xF0,0x88,0xF0,0x00,0xF0,0x00},	// 0xA6
{0x30,0x48,0x48,0x48,0x30,0x00,0x78,0x00},	// 0xA7
{0x20,0x00,0x20,0x30,0x08,0x88,0x70,0x00},	// 0xA8
{0x78,0xA4,0xD4,0xB4,0xD4,0x84,0x78,0x00},	// 0xA9
{0x00,0x00,0xFC,0x80,0x80,0x00,0x00,0x00},	// 0xAA
{0x08,0x48,0x28,0x70,0x88,0x40,0xE0,0x00},	// 0xAB
{0x08,0x48,0x28,0xD0,0xA8,0xE0,0x80,0x00},	// 0xAC
{0x20,0x00,0x20,0x20,0x70,0x70,0x20,0x00},	// 0xAD
{0x00,0x00,0x90,0x48,0x90,0x00,0x00,0x00},	// 0xAE
{0x00,0x00,0x48,0x90,0x48,0x00,0x00,0x00},	// 0xAF
{0xA8,0x00,0x54,0x00,0xA8,0x00,0x54,0x00},	// 0xB0
{0xA8,0x54,0xA8,0x54,0xA8,0x54,0xA8,0x54},	// 0xB1
{0x54,0xFC,0xA8,0xFC,0x54,0xFC,0xA8,0xFC},	// 0xB2
{0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20},	// 0xB3
{0x20,0x20,0x20,0x3C,0x20,0x20,0x20,0x20},	// 0xB4
{0x60,0x00,0x20,0x50,0x88,0xF8,0x88,0x00},	// 0xB5
{0x70,0x00,0x20,0x50,0x88,0xF8,0x88,0x00},	// 0xB6
{0x30,0x00,0x20,0x50,0x88,0xF8,0x88,0x00},	// 0xB7
{0x78,0x84,0xB4,0x94,0xB4,0x84,0x78,0x00},	// 0xB8
{0x28,0x2C,0x20,0x2C,0x28,0x28,0x28,0x28},	// 0xB9
{0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28},	// 0xBA
{0x00,0x3C,0x20,0x2C,0x28,0x28,0x28,0x28},	// 0xBB
{0x28,0x2C,0x20,0x3C,0x00,0x00,0x00,0x00},	// 0xBC
{0x00,0x20,0x70,0x08,0x08,0x70,0x20,0x00},	// 0xBD
{0x88,0x50,0x20,0xF8,0x20,0xF8,0x20,0x00},	// 0xBE
{0x00,0x00,0x00,0x3C,0x20,0x20,0x20,0x20},	// 0xBF
{0x20,0x20,0x20,0xE0,0x00,0x00,0x00,0x00},	// 0xC0
{0x20,0x20,0x20,0xFC,0x00,0x00,0x00,0x00},	// 0xC1
{0x00,0x00,0x00,0xFC,0x20,0x20,0x20,0x20},	// 0xC2
{0x20,0x20,0x20,0xE0,0x20,0x20,0x20,0x20},	// 0xC3
{0x88,0x70,0x88,0x88,0xF8,0x88,0x88,0x00},	// 0xC4  / A Umlaut
{0x20,0x20,0x20,0xFC,0x20,0x20,0x20,0x20},	// 0xC5
{0xA0,0x50,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0xC6
{0xA0,0x50,0x20,0x50,0x88,0xF8,0x88,0x00},	// 0xC7
{0x28,0xE8,0x08,0xF8,0x00,0x00,0x00,0x00},	// 0xC8
{0x00,0xF8,0x08,0xE8,0x28,0x28,0x28,0x28},	// 0xC9
{0x28,0xEC,0x00,0xFC,0x00,0x00,0x00,0x00},	// 0xCA
{0x00,0xFC,0x00,0xEC,0x28,0x28,0x28,0x28},	// 0xCB
{0x28,0xE8,0x08,0xE8,0x28,0x28,0x28,0x28},	// 0xCC
{0x00,0xFC,0x00,0xFC,0x00,0x00,0x00,0x00},	// 0xCD
{0x28,0xEC,0x00,0xEC,0x28,0x28,0x28,0x28},	// 0xCE
{0x88,0x70,0x88,0x88,0x88,0x70,0x88,0x00},	// 0xCF
{0x30,0x08,0x10,0x20,0x70,0x48,0x30,0x00},	// 0xD0
{0x70,0x90,0x90,0xB8,0x90,0x90,0x70,0x00},	// 0xD1
{0x70,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00},	// 0xD2
{0x50,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00},	// 0xD3
{0x30,0x00,0xF8,0x08,0x78,0x08,0xF8,0x00},	// 0xD4
{0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00},	// 0xD5
{0x88,0x70,0x88,0x88,0x88,0x88,0x70,0x00},	// 0xD6  / O Umlaut
{0x70,0x00,0x70,0x20,0x20,0x20,0x70,0x00},	// 0xD7
{0x50,0x00,0x70,0x20,0x20,0x20,0x70,0x00},	// 0xD8
{0x20,0x20,0x20,0x3C,0x00,0x00,0x00,0x00},	// 0xD9
{0x00,0x00,0x00,0xE0,0x20,0x20,0x20,0x20},	// 0xDA
{0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC},	// 0xDB
{0x88,0x00,0x88,0x88,0x88,0x88,0x70,0x00},	// 0xDC  / U Umlaut
{0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00},	// 0xDD
{0x30,0x00,0x70,0x20,0x20,0x20,0x70,0x00},	// 0xDE
{0x00,0x38,0x48,0x38,0x48,0x48,0x38,0x08},	// 0xDF  / sz Ligatur
{0x60,0x30,0x48,0x48,0x48,0x48,0x30,0x00},	// 0xE0
{0x00,0x38,0x48,0x38,0x48,0x48,0x38,0x08},	// 0xE1
{0x70,0x30,0x48,0x48,0x48,0x48,0x30,0x00},	// 0xE2
{0x18,0x30,0x48,0x48,0x48,0x48,0x30,0x00},	// 0xE3
{0x88,0x00,0x70,0x80,0xF0,0x88,0xF0,0x00},	// 0xE4  / a Umlaut
{0x50,0x28,0x30,0x48,0x48,0x48,0x30,0x00},	// 0xE5
{0x00,0x00,0x48,0x48,0x48,0x38,0x08,0x08},	// 0xE6
{0x00,0x18,0x08,0x38,0x48,0x38,0x08,0x18},	// 0xE7
{0x18,0x08,0x38,0x48,0x48,0x38,0x08,0x18},	// 0xE8
{0x60,0x00,0x48,0x48,0x48,0x48,0x30,0x00},	// 0xE9
{0x70,0x00,0x48,0x48,0x48,0x48,0x30,0x00},	// 0xEA
{0x18,0x00,0x48,0x48,0x48,0x48,0x30,0x00},	// 0xEB
{0x60,0x00,0x48,0x48,0x48,0x70,0x20,0x18},	// 0xEC
{0x60,0x00,0x88,0x50,0x20,0x20,0x20,0x00},	// 0xED
{0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00},	// 0xEE
{0x30,0x30,0x10,0x00,0x00,0x00,0x00,0x00},	// 0xEF
{0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00},	// 0xF0
{0x00,0x20,0x70,0x20,0x00,0x70,0x00,0x00},	// 0xF1
{0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00},	// 0xF2
{0x0C,0x58,0x2C,0xD0,0xA8,0xE0,0x80,0x00},	// 0xF3
{0xF0,0xA8,0xA8,0xB0,0xA0,0xA0,0xA0,0x00},	// 0xF4
{0x70,0x88,0x30,0x50,0x60,0x88,0x70,0x00},	// 0xF5
{0x88,0x00,0x70,0x88,0x88,0x88,0x70,0x00},	// 0xF6  / o Umlaut
{0x00,0x00,0x00,0x70,0x60,0x00,0x00,0x00},	// 0xF7
{0x30,0x48,0x48,0x30,0x00,0x00,0x00,0x00},	// 0xF8
{0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x00},	// 0xF9
{0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00},	// 0xFA
{0x10,0x18,0x10,0x10,0x00,0x00,0x00,0x00},	// 0xFB
{0x48,0x00,0x48,0x48,0x48,0x68,0x50,0x00},	// 0xFC  / u Umlaut
{0x18,0x20,0x10,0x38,0x00,0x00,0x00,0x00},	// 0xFD
{0x00,0x00,0x78,0x78,0x78,0x78,0x00,0x00},	// 0xFE
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00} 	// 0xFF
};