/*
 * Sehr einfache WLAN-Anbindung mit ESP8266
 * Florian SchÃ¤ffer, Redaktion Make: http://www.make-magazin.de/
 * VII/2016
 * 
 * Verbindet sich zu OpenWeather.org und ruft die Daten eines Ortes ab.
 * Man benoetigt eine eigen APP-ID von OpenWeather
 * Die Orte koennen ueber Ortsnamen oder IDs angegeben werden
 */

#include <SoftwareSerial.h>

const String MYSSID = "xxx";           // case sensitive!
const String MYPASSWD = "xxx";
const String DST_IP = "api.openweathermap.org";           
const String WLOCATIONID = "id=2910831";                 // Hannover
//const String WLOCATIONID = "id=3426466";                 // Grytviken
//const String WLOCATIONID = "q=hannover,de";                 // ACHTUNG: "q=" fuer Ortsnamen, "id=" fuer IDs
const String WAPPID = "xxx";				// API von openweather
const String WADDITIONAL = "&mode=json&lang=de&units=metric";

boolean connectWiFi(void);
int8_t espInit(void);
void holedata (void);

SoftwareSerial esp8266Serial(10, 11); // RX, TX

boolean connectWiFi(void)
{
  //Serial.println("AT+CWMODE=1");
  String cmd="AT+CWJAP=\"";
  cmd+=MYSSID;
  cmd+="\",\"";
  cmd+=MYPASSWD;
  cmd+="\"";
  esp8266Serial.println(cmd);
  //Serial.println(cmd);
  delay(2000);
  if(esp8266Serial.find((char*)"OK"))
  {
    //Serial.println("OK, Connected to WiFi.");
    return true;
  }
  else
  {
    //Serial.println("Can not connect to the WiFi.");
    return false;
  }
}

int8_t espInit(void)
{
  writechar ('W', 0, 0);
  esp8266Serial.begin(9600);
  esp8266Serial.setTimeout(5000);
  //Serial.println("WiFi - Module reset");
  esp8266Serial.println("AT+RST");
  delay(1000);


  if(esp8266Serial.find((char*)"OK")) 
  {
    Serial.println("RDY");
  }
  else
  {
    Serial.println("Module not respond.");
  }
  
  // try to connect to wifi
  boolean connected=false;
  for(int i=0;i<5;i++)
  {
    if(connectWiFi())
    {
      connected = true;
      //Serial.println("Connected to WiFi...");
      writechar ('+', 0, 0);
      break;
     }
  }
  if (!connected)
  {
    //Serial.println("Coud not connect to WiFi.");
    writechar ('-', 0, 0);
    return -1;
  }
  delay(5000);

  esp8266Serial.println("AT+CIPMUX=0"); // set to single connection mode
  //Serial.println("set to single connection mode");

  delay(300);  
  return 0;
}

void holedata (void)
{
  while(1)
  {
    String cmd = "AT+CIPSTART=\"TCP\",\"";
    cmd += DST_IP;
    cmd += "\",80";
    Serial.println(cmd);
    esp8266Serial.println(cmd);
    
    if(esp8266Serial.find((char*)"Error")) return;
    
    cmd = "GET /data/2.5/weather?" + WLOCATIONID;
    cmd += "&appid=" + WAPPID;
    cmd += WADDITIONAL;
    cmd += " HTTP/1.0\r\nHost:api.openweathermap.org\r\n\r\n";
  
    //Serial.println(cmd);
    //Serial.println(cmd.length());
    
    esp8266Serial.print("AT+CIPSEND=");
    esp8266Serial.println(cmd.length());
  
    delay(500);
  
    
    if(esp8266Serial.find((char*)">"))
    {
      //Serial.print(">");
    }
    else
    {
      esp8266Serial.println("AT+CIPCLOSE");
      //Serial.println("connection timeout");
      delay(1000);
      return;
    }
    
    //Serial.print(cmd);
    esp8266Serial.print(cmd);
  
  
    /*
     * Beispielantwort:
     *
     * SEND OK
     * 
     * +IPD,809:HTTP/1.1 200 OK
     * Server: openresty
     * Date: Wed, 20 Jul 2016 12:12:39 GMT
     * Content-Type: application/json; charset=utf-8
     * Content-Length: 457
     * Connection: close
     * X-Cache-Key: /data/2.5/weather?lang=de&mode=json&q=hannover,de&units=metric
     * Access-Control-Allow-Origin: *
     * Access-Control-Allow-Credentials: true
     * Access-Control-Allow-Methods: GET, POST
     *
     * <current><city id="2910831" name="Hannover"><coord lon="9.73" lat="52.37"></coord><country>DE</country><sun rise="2016-07-20T03:24:35" set="2016-07-20T19:29:30"></sun></city><temperature value="25.17" min="22.6" max="27.78" unit="metric"></temperature><humidity value="57" unit="%"></humidity><pressure value="1018" unit="hPa"></pressure><wind><speed value="3.1" name="Light breeze"></speed><gusts></gusts><direction value="120" code="ESE" name="East-southeast"></direction></wind><clouds value="0" name="clear sky"></clouds><visibility></visibility><precipitation mode="no"></precipitation><weather number="800" value="klarer Himmel" icon="01d"></weather><lastupdate value="2016-07-20T08:30:47"></lastupdate></current>
     * 
     * --------------------------
     * 
     *  <current>
     *     <city id="2910831" name="Hannover">
     *        <coord lon="9.73" lat="52.37" />
     *        <country>DE</country>
     *        <sun rise="2016-07-20T03:24:32" set="2016-07-20T19:29:33" />
     *     </city>
     *     <temperature value="23.22" min="20.2" max="26.67" unit="metric" />
     *     <humidity value="64" unit="%" />
     *     <pressure value="1018" unit="hPa" />
     *     <wind>
     *        <speed value="2.6" name="Light breeze" />
     *        <gusts />
     *        <direction value="120" code="ESE" name="East-southeast" />
     *     </wind>
     *     <clouds value="0" name="clear sky" />
     *     <visibility />
     *     <precipitation mode="no" />
     *     <weather number="800" value="klarer Himmel" icon="01d" />
     *     <lastupdate value="2016-07-20T07:20:00" />
     *  </current>      
     * 
     */
     
    uint32_t i = 0; //timeout counter
    char datum[22] = {0};
    char ort[23] = {0};
    uint8_t cntOrt = 0;
    char temp[6] = {0};
    uint8_t cnttemp = 0;
    char c;
    
    while (!esp8266Serial.find((char*)"Date: "));   // empfange/verwerfe bis "Date: "
  
    // Das gleichzeitige Ausgeben auf dem Display dauert zu lange => erst alles einlesen, dann ausgeben
    for (i = 0; i <= 22; i++)       // "Thu, 21 Jul 2016 06:50" einlesen (":48 GMT" nicht)
    {
      while (!esp8266Serial.available());   // warte auf Zeichen
      datum[i]  = esp8266Serial.read();
      //Serial.print(datum[i]);
    }

    // Temp einlesen
    while (!esp8266Serial.find((char*)"temp\":"));   // empfange/verwerfe bis 'temp":'
    do
    {
      while (!esp8266Serial.available());   // warte auf Zeichen
      temp[cnttemp] = esp8266Serial.read();
//      Serial.print(temp[cnttemp]);
      cnttemp++;
    } while (temp[cnttemp-1] != ',');    // bis Komma


    // Ort einlesen
    while (!esp8266Serial.find((char*)"name\":\""));   // empfange/verwerfe bis 'name":"'
    do
    {
      while (!esp8266Serial.available());   // warte auf Zeichen
      ort[cntOrt] = esp8266Serial.read();
//      Serial.print(ort[cntOrt]);
      cntOrt++;
    } while ((ort[cntOrt-1] != '"') && (cntOrt < 23));    // bis Anfuehrungszeichen (nicht maskieren)/(bevor cntOrt inkrementiert wurde) aber maximal 23 Zeichen
  
    // ######################### Ausgabe
  
    for (i = 0; i <= 10; i++)                // "20 Jul 2016" ausgeben (ohne die ersten 5 Zeichen)
      writechar (datum[i+5], i * 6, 0);
  
    for (i = 0; i <= 4; i++)                  // "12:16" ausgeben
      writechar (datum[i+17], 86 + i * 6, 0);
  
    writechar ('G', 122, 0);
    writechar ('M', 128, 0);
    writechar ('T', 134, 0);
  
    for (i = 0; i < (cntOrt-1); i++)                // Ort ausgeben, ohne letztes Zeichen (") und cnt ist bereits eins zu weit
      writechar (ort[i], i * 6, 8);
  
    for (i = 0; i < (cnttemp-1); i++)      // Temp, ohne letztes Zeichen (") und cnt ist bereits eins zu weit
      writechar (temp[i], i * 6, 16);
  
    //writechar (32, i*6 + 6, 16);
    writechar (248, i*6 + 6, 16);      // Gradzeichen
    writechar ('C', i*6 + 12, 16);      // ein Leerzeichen zum loeschen, falls Ausgabe kuerzer wird
    writechar (32, i*6 + 18, 16);       // ein Leerzeichen zum loeschen, falls Ausgabe kuerzer wird
  
    delay (20000);    // Server entlasten
  }

}



