const unsigned long BAUD_RATE = 9600;
const unsigned char MIKROFON = A0;
const unsigned char LED_ROT = 8;
const unsigned char LED_GELB = 9;
const unsigned char LED_GRUEN = 10;
const unsigned int SCHWELLE_ROT = 35;
const unsigned int SCHWELLE_GELB = 25;
const unsigned int LEUCHT_DAUER = 500;

void setup() {
  pinMode(LED_ROT, OUTPUT);
  pinMode(LED_GELB, OUTPUT);
  pinMode(LED_GRUEN, OUTPUT);
  Serial.begin(BAUD_RATE);
}

void loop() {  
  unsigned int pegel = analogRead(MIKROFON);
  int differenz = pegel - 511;
  unsigned int lautstaerke = abs(differenz) / 10;

  if (lautstaerke > SCHWELLE_ROT) {
    Serial.println("Zu laut!");
    schalte_ampel(HIGH, LOW, LOW);
    delay(LEUCHT_DAUER);
  }  else if (lautstaerke > SCHWELLE_GELB){
    Serial.println("Ziemlich laut.");
    schalte_ampel(LOW, HIGH, LOW);
    delay(LEUCHT_DAUER);
  } else {
    Serial.println("Alles ruhig.");
    schalte_ampel(LOW, LOW, HIGH);
  }
}

void schalte_ampel(unsigned int rot, unsigned int gelb, unsigned int gruen) {
  digitalWrite(LED_ROT, rot);
  digitalWrite(LED_GELB, gelb);
  digitalWrite(LED_GRUEN, gruen);
}

