#include "Tonhoehe.h"

const unsigned char LAUTSPRECHER_PIN = 9;
const unsigned int GANZE_NOTE = 1000;

struct Note {
  Tonhoehe frequenz;
  unsigned char laenge; // 4 = Viertelnote, 8 = Achtelnote etc.
};

Note melodie[] = {
  { NOTE_C4, 4 }, { NOTE_G3, 8 },
  { NOTE_G3, 8 }, { NOTE_A3, 4 },
  { NOTE_G3, 4 }, { PAUSE,   4 },
  { NOTE_B3, 4 }, { NOTE_C4, 4 }
};

void setup() { }

void loop() {
  unsigned int anzahl_noten = sizeof(melodie) / sizeof(melodie[0]);
  for (unsigned int note = 0; note < anzahl_noten; note++) {
    unsigned int notenLaenge = GANZE_NOTE / melodie[note].laenge;
    tone(LAUTSPRECHER_PIN, melodie[note].frequenz, notenLaenge);
    unsigned int pauseZwischenNoten = notenLaenge * 1.30;
    delay(pauseZwischenNoten);
  }
  delay(3000);
}

