#include <OneWire.h>
#include <DallasTemperature.h>

const unsigned long BAUD_RATE = 9600;
const unsigned char ONE_WIRE_BUS = 4;

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensoren(&oneWire);

DeviceAddress sensorKennung;

void setup() {
  Serial.begin(BAUD_RATE);
  sensoren.begin();
}

void loop() {
  if (sensoren.getAddress(sensorKennung, 0) == 0) {
    Serial.println("Die Kennung des Sensors konnte nicht ermittelt werden."); 
  } else {
    for (unsigned char i = 0; i < 8; i++) {
      Serial.print(sensorKennung[i]);
      if (i < 7) {
        Serial.print(", ");
      }
    }
    Serial.println();
  }
  delay(1000);
}

