#include <OneWire.h>
#include <DallasTemperature.h>
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

const unsigned char ONE_WIRE_BUS = 4;
const unsigned char OLED_RESET = 5;

Adafruit_SSD1306 display(OLED_RESET);
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensoren(&oneWire);

// Die folgenden beiden Werte müssen an die eigenen Sensoren
// angepasst werden.
DeviceAddress innenThermometer = { 40, 255, 221, 30, 101, 21, 2, 232 };
DeviceAddress aussenThermometer = { 40, 255, 1, 17, 101, 21, 2, 13 };

void setup() {
  sensoren.begin();
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(4, 23);
  display.print("Anzahl Sensoren: ");
  display.setCursor(106, 23);
  display.println(sensoren.getDeviceCount());
  display.setCursor(4, 33);
  display.print("Modus: ");
  display.setCursor(46, 33);
  if (sensoren.isParasitePowerMode()) {
    display.print("Parasitaer");
  } else {
    display.print("Normal");
  }
  display.display();
  delay(3000);
}

void loop() {
  sensoren.requestTemperatures();
  float innenTemperatur = sensoren.getTempC(innenThermometer);
  float aussenTemperatur = sensoren.getTempC(aussenThermometer);
  
  display.clearDisplay();
  display.setCursor(24, 0);
  display.println("Temperaturen");
  display.drawLine(0, 9, display.width(), 9, WHITE);
  
  display.setCursor(1, 27);
  display.print("Aussen: ");
  display.setCursor(44, 27);
  display.print(aussenTemperatur);
  display.setCursor(77, 27);
  display.print("C");
  
  display.setCursor(1, 37);
  display.print("Innen: ");
  display.setCursor(44, 37);
  display.print(innenTemperatur);
  display.setCursor(77, 37);
  display.print("C");
  
  display.display();
  delay(1000);
}

