import processing.serial.*;
import cc.arduino.*;

final byte THERMOMETER_PIN = 0;
final int ZEICHEN_GROESSE = 32;

Arduino arduino;

void setup() {
  size(320, 240);
  String arduinoPort = "/dev/cu.usbmodem24311"; // Hier anpassen!
  arduino = new Arduino(this, arduinoPort);
  PFont zeichensatz = createFont("Arial", ZEICHEN_GROESSE, true);
  textFont(zeichensatz, ZEICHEN_GROESSE);
}

void draw() {
  background(255);
  fill(0);
  textAlign(CENTER, CENTER);
  float spannung = arduino.analogRead(THERMOMETER_PIN) * 5000 / 1024.0;
  float temperatur = (spannung - 500) / 10; // TMP36
  // float temperatur = spannung / 10;  // LM35 CZ
  String temperaturText = nf(temperatur, 0, 1);
  System.out.println(temperaturText);
  text(temperaturText + " \u2103", width / 2, height / 2);
  delay(1000);
}