// ----------------------------
// --- 7 Segmant with Servo ---
// ---  Andreas Engel 2016  ---
// ----------------------------
#include <Servo.h>

Servo sec_1_1;              // Erste 7 Segment Anzeige Servo 1
Servo sec_1_2;             // Erste 7 Segment Anzeige Servo 2
Servo sec_1_3;            // Erste 7 Segment Anzeige Servo 3
Servo sec_1_4;          // Erste 7 Segment Anzeige Servo 4

byte Setup = false;  // Wenn auf true gesetzt dann gehen alle Servos auf 0

int Digit_1_S1[10]={80,0,0,0,80,80,80,0,80,80};         // Servo setup 0,90,180 Grad. Manchmal ist eine kleine Anpassung nötig
int Digit_1_S2[10]={80,170,0,80,170,0,0,80,80,80};
int Digit_1_S3[10]={155,155,0,75,75,75,75,155,75,75};
int Digit_1_S4[10]={165,0,165,75,0,75,165,0,165,75};

int slowdown = 10;  // ms um Servo Geschwindigkeit (und Geräuschpegel) zu reduzieren

void setup() {
   Serial.begin(9600);
   sec_1_1.attach(6);         // attaches the servo 1 to pin D6 servo object
   sec_1_2.attach(9);        // attaches the servo 2 to pin D9 servo object
   sec_1_3.attach(10);      // attaches the servo 3 to pin D10 servo object
   sec_1_4.attach(11);     // attaches the servo 4 to pin D11 servo object
   pinMode(13, INPUT);    // Pin 13 ist der Würfel eingang
   Turn_Servo_to(0);     // 0 Anzeigen
}

void loop() {
    if (digitalRead(13)==true)    // Wenn Taster gedrückt
    {
      Turn_Servo_to(0);             // dann erst mal 0 anzeigen
      Turn_Servo_to(random(5)+1);  // dann per Zufall eine Zahl anzeigen
      delay(2000);                // 2 sek. warten
      Turn_Servo_to(0);             // dann erst mal 0 anzeigen
      Turn_Servo_to(random(5)+1);  // dann per Zufall eine Zahl anzeigen
    }
}
// ------------------------------------------------------------------
// ------------------------------------------------------------------
void Turn_Servo_to(int Zahl){

       Serial.println(Zahl);
      
      //--- Servo 1
       int pos_from=sec_1_1.read();     // where is the Servo
       int pos_to=Digit_1_S1[Zahl];    // where should it go to
       if (pos_from!=pos_to){         // if no change then do nothing
          if (pos_from < pos_to) {        // if new position now smaller then add
            for (int x=pos_from; x<=pos_to; x++){   // until new position reached
              sec_1_1.write(x);                    // tell servo to go to new position
              delay(slowdown);                    // delay until position reached
            }
          }
          else                            // else new position now bigger then subtract
          {
           for (int x=pos_from; x>=pos_to; x--){    // until new position reached
              sec_1_1.write(x);                    // tell servo to go to position
              delay(slowdown);                    // delay
            }    
          }
       }
       
      //--- Servo 2
       pos_from=sec_1_2.read();
       pos_to=Digit_1_S2[Zahl];
       if (pos_from!=pos_to){
          if (pos_from < pos_to) { 
            for (int x=pos_from; x<=pos_to; x++){
              sec_1_2.write(x);              // tell servo to go to position
              delay(slowdown);
            }
          }
          else
          {
           for (int x=pos_from; x>=pos_to; x--){
              sec_1_2.write(x);              // tell servo to go to position
              delay(slowdown); 
            }    
          }
       }

      //--- Servo 3
       pos_from=sec_1_3.read();
       pos_to=Digit_1_S3[Zahl];
       if (pos_from!=pos_to){
          if (pos_from < pos_to) { 
            for (int x=pos_from; x<=pos_to; x++){
              sec_1_3.write(x);              // tell servo to go to position
              delay(slowdown);
            }
          }
          else
          {
           for (int x=pos_from; x>=pos_to; x--){
              sec_1_3.write(x);              // tell servo to go to position
              delay(slowdown); 
            }    
          }
       }

      //--- Servo 4
       pos_from=sec_1_4.read();
       pos_to=Digit_1_S4[Zahl];
       if (pos_from!=pos_to){
          if (pos_from < pos_to) { 
            for (int x=pos_from; x<=pos_to; x++){
              sec_1_4.write(x);              // tell servo to go to position
              delay(slowdown);
            }
          }
          else
          {
           for (int x=pos_from; x>=pos_to; x--){
              sec_1_4.write(x);              // tell servo to go to position
              delay(slowdown); 
            }    
          }
       }
}

//--- Servo Home all Arms can be adjusted
void All_Servo_Home(int degree) {
       sec_1_1.write(degree);              // tell servo 1 to go to position degree
       sec_1_2.write(degree);              // tell servo 2 to go to position degree
       sec_1_3.write(degree);              // tell servo 3 to go to position degree
       sec_1_4.write(degree);              // tell servo 4 to go to position degree
       Serial.print("All Servo Set to ");
       Serial.println(degree);
       delay(5000);
}

