/*
 * XXL Anzeige Servos-7-Segment
 * zieht Zufallszahl nach Tastendruck
 */
 
#include <Servo.h>

Servo sec_1_1;              // Erste 7 Segment Anzeige Servo 1
Servo sec_1_2;             // Erste 7 Segment Anzeige Servo 2
Servo sec_1_3;            // Erste 7 Segment Anzeige Servo 3
Servo sec_1_4;          // Erste 7 Segment Anzeige Servo 4

byte Setup = false;  // Wenn auf true gesetzt dann gehen alle Servos auf 0
int slowdown = 10;  // ms um Servo Geschwindigkeit (und Geräuschpegel) zu reduzieren
#define PINTASTE 2   // I/O für Taste

int Digit_1_S1[10]={77,167,167,167,77,77,77,167,77,77};         // Servo setup 0,90,180 Grad. Manchmal ist eine kleine Anpassung nötig
int Digit_1_S2[10]={85,0,172,85,0,172,172,85,85,85};
int Digit_1_S3[10]={4,4,180,91,91,91,91,4,91,91};
int Digit_1_S4[10]={8,180,8,92,180,92,8,180,8,92};


void setup() {
   sec_1_1.attach(14);         // attaches the servo 1 to pin 
   sec_1_2.attach(15);        // attaches the servo 2 to pin 
   sec_1_3.attach(16);      // attaches the servo 3 to pin 
   sec_1_4.attach(17);     // attaches the servo 4 to pin 

   pinMode(PINTASTE, INPUT_PULLUP);
  
  if (Setup)
    All_Servo_Home (0);    
}

void loop() 
{
  Turn_Servo_to(8);   // Startzahl
  
  while (1)
  {
    while (digitalRead(PINTASTE) == 1);    // solange Taste High (int. Pull-Up): warte
    
    Turn_Servo_to(random(9));     // per Zufall eine Zahl anzeigen 0..9
  }
}

// ------------------------------------------------------------------
// ------------------------------------------------------------------
void Turn_Servo_to(int Zahl){

       Serial.println(Zahl);
      
      //--- Servo 1
       int pos_from=sec_1_1.read();     // where is the Servo
       int pos_to=Digit_1_S1[Zahl];    // where should it go to
       if (pos_from!=pos_to){         // if no change then do nothing
          if (pos_from < pos_to) {        // if new position now smaller then add
            for (int x=pos_from; x<=pos_to; x++){   // until new position reached
              sec_1_1.write(x);                    // tell servo to go to new position
              delay(slowdown);                    // delay until position reached
            }
          }
          else                            // else new position now bigger then subtract
          {
           for (int x=pos_from; x>=pos_to; x--){    // until new position reached
              sec_1_1.write(x);                    // tell servo to go to position
              delay(slowdown);                    // delay
            }    
          }
       }
       
      //--- Servo 2
       pos_from=sec_1_2.read();
       pos_to=Digit_1_S2[Zahl];
       if (pos_from!=pos_to){
          if (pos_from < pos_to) { 
            for (int x=pos_from; x<=pos_to; x++){
              sec_1_2.write(x);              // tell servo to go to position
              delay(slowdown);
            }
          }
          else
          {
           for (int x=pos_from; x>=pos_to; x--){
              sec_1_2.write(x);              // tell servo to go to position
              delay(slowdown); 
            }    
          }
       }

      //--- Servo 3
       pos_from=sec_1_3.read();
       pos_to=Digit_1_S3[Zahl];
       if (pos_from!=pos_to){
          if (pos_from < pos_to) { 
            for (int x=pos_from; x<=pos_to; x++){
              sec_1_3.write(x);              // tell servo to go to position
              delay(slowdown);
            }
          }
          else
          {
           for (int x=pos_from; x>=pos_to; x--){
              sec_1_3.write(x);              // tell servo to go to position
              delay(slowdown); 
            }    
          }
       }

      //--- Servo 4
       pos_from=sec_1_4.read();
       pos_to=Digit_1_S4[Zahl];
       if (pos_from!=pos_to){
          if (pos_from < pos_to) { 
            for (int x=pos_from; x<=pos_to; x++){
              sec_1_4.write(x);              // tell servo to go to position
              delay(slowdown);
            }
          }
          else
          {
           for (int x=pos_from; x>=pos_to; x--){
              sec_1_4.write(x);              // tell servo to go to position
              delay(slowdown); 
            }    
          }
       }
}

//--- Servo Home all Arms can be adjusted
void All_Servo_Home(int degree) {
       sec_1_1.write(degree);              // tell servo 1 to go to position degree
       sec_1_2.write(degree);              // tell servo 2 to go to position degree
       sec_1_3.write(degree);              // tell servo 3 to go to position degree
       sec_1_4.write(degree);              // tell servo 4 to go to position degree
       Serial.print("All Servo Set to ");
       Serial.println(degree);
       while (1);
}

