#include <SoftwareSerial.h>
#include <SD.h> 
#include <TinyGPS.h>
#include <MsTimer2.h>
#include <LiquidCrystal.h>
LiquidCrystal lcd(10, 9, 8, 7, 6, 5);
const uint8_t SD_pin=2;
uint8_t ausgabe; 
volatile uint16_t start_stop=0;
boolean alt_neu=true, start=true, abbruch=false;
uint32_t distanz=0;
const float eps=0.000001;
File dataFile;
/* Anschluss GPS-Modul:
 *  Rx  Pin 3
 *  Tx  Pin 4
 *  
 *  Anschluss SD-Karte:
 *      Uno       
 *  MOSI Pin 11    
 *  MISO Pin 12  
 *  SCK  Pin 13    
 *  CS   Pin 2   
 *  
 *  Anschluss Kristallanzeige:
 *  VSS   Ground 
 *  VDD   mit 430 Ohm-Widerstand an Plus 5 Volt
 *  VO    Ground
 *  RS    Pin 10
 *  RW    Ground
 *  E     Pin 9
 *  D4    Pin 8
 *  D5    Pin 7
 *  D6    Pin 6
 *  D7    Pin 5
 *  Led+  mit 220 Ohm-Widerstand an Plus 5 Volt
 *  Led-  Ground
*/
TinyGPS gps;
SoftwareSerial ss(4, 3);
static void smartdelay(unsigned long ms);
static void print_float(float val, int prec, File dataFile);
static void print_int(unsigned long val, File dataFile);
static void print_date(TinyGPS &gps, File dataFile);
void taster() {             //Auslesen des Analogeinganges vom Taster
  start_stop=analogRead(A0);
}
void setup()
{
  ss.begin(9600);
  lcd.begin(16, 2);
  if (!SD.begin(SD_pin)) {
   lcd.print("Keine SD-Karte !");
   lcd.setCursor(0, 1);
   lcd.print("Programmabbruch!");    
   abbruch=true;
   return;                    //Programmabbruch
  }
  if (SD.exists("routelog.txt")) SD.remove("routelog.txt");     //Anlegen der Logdatei
  dataFile = SD.open("routelog.txt", FILE_WRITE);
  dataFile.print("Datum  ");
  dataFile.print("Uhrzeit  ");
  dataFile.print("Satelliten  ");
  dataFile.print("Konsistenz  ");
  dataFile.print("Breitengrad  ");
  dataFile.print("Längengrad  ");
  dataFile.print("Höhe  ");
  dataFile.print("Geschwindigkeit  ");
  dataFile.print("Teilstrecke  ");
  dataFile.print("Gesamtstrecke  ");
  dataFile.println("Summenfehler  ");
  lcd.setCursor(4, 0);  
  lcd.print("Logdatei" );
  lcd.setCursor(1, 1);
  lcd.print("ist angelegt !");
  delay(2000); 
  MsTimer2::set(700, taster);
  MsTimer2::start();
}
void loop()
{
  while(abbruch); //Endlosschleife, wenn keine SD-Karte feststellbar war oder die Aufzeichnung beendet wurde
  float flat, flon, flat_alt, flon_alt;
  unsigned long age, date, time, chars = 0;
  unsigned short sentences = 0, failed = 0;  
  if (start) {
    start=false;  
    lcd.clear();
    lcd.setCursor(2, 0);
    lcd.print("Auf GPS-Daten");
    lcd.setCursor(4, 1);   
    lcd.print("warten!");
    do {                  //Auf gültige GPS-Daten warten
      gps.f_get_position(&flat, &flon, &age);   
      smartdelay(500);  
    } while(abs(flat-TinyGPS::GPS_INVALID_F_ANGLE)<eps);
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("Bitte Startknopf");
    lcd.setCursor(3, 1);    
    lcd.print("druecken!");    
  }
  if(start_stop>1000){    //Warten, bis Startknopf gedrückt wurde
    start_stop=500;      //Startwert auf jeden Fall zunächst zurücksetzen
    ausgabe=1;    
    while (start_stop<1000){
      gps.f_get_position(&flat, &flon, &age);
      if(alt_neu){                  //Bei den ersten gültigen Positionsangaben diese auch als   
        flat_alt=flat;              //erste Altdaten definieren
        flon_alt=flon;
        alt_neu=false;
        distanz=0;                  //Gesamtstrecke zurücksetzen
        lcd.clear();
        lcd.setCursor(2, 0);
        lcd.print("Aufzeichnung");
        lcd.setCursor(4, 1);    
        lcd.print("startet!"); 
        delay(1000);       
      }
      print_date(gps, dataFile);      
      print_int(gps.satellites(), dataFile);
      print_int(gps.hdop(), dataFile);
      print_float(flat, 6, dataFile);
      print_float(flon, 6, dataFile);
      print_float(gps.f_altitude(), 2, dataFile);
      print_float(gps.f_speed_kmph(), 2, dataFile);
      print_int((unsigned long)TinyGPS::distance_between(flat, flon, flat_alt, flon_alt), dataFile);
      distanz=distanz+TinyGPS::distance_between(flat, flon, flat_alt, flon_alt);
      ausgabe++;         
      if(ausgabe==2){         //Nur jeden zweiten Messwert anzeigen
        lcd.clear();
        lcd.setCursor(0, 0);
        lcd.print("km/h:");
        lcd.setCursor(6, 0);            
        lcd.print(gps.f_speed_kmph());
        lcd.setCursor(0, 1);
        lcd.print("Meter:");
        lcd.setCursor(7, 1);
        lcd.print(distanz);  
        ausgabe=0;            //Zähler für Messwerte zurücksetzen
      }
      dataFile.print("  ");
      dataFile.print(distanz);
      dataFile.print("  ");
      flat_alt=flat;
      flon_alt=flon;
      gps.stats(&chars, &sentences, &failed);
      print_int(failed, dataFile);
      dataFile.println();  
      smartdelay(500);
    } 
    dataFile.println();
    dataFile.println("Ende der Aufzeichnung!");   
    dataFile.close();
    lcd.clear();
    lcd.setCursor(2, 0);
    lcd.print("Aufzeichnung");
    lcd.setCursor(4, 1);
    lcd.print("beendet!");
    MsTimer2::stop();
    abbruch=true;
  }
}
static void smartdelay(unsigned long ms)
{
  unsigned long start = millis();
  do 
  {
    while (ss.available())
      gps.encode(ss.read());
  } while (millis() - start < ms);
}
static void print_float(float val, int prec, File dataFile)
{
  String konvert;
  konvert=String(val, prec);                      //Fließkommazahl in deutsche Notation umwandeln
  konvert.replace(".", ",");
  dataFile.print(konvert);
  dataFile.print("  ");
  smartdelay(0);
}
static void print_int(unsigned long val, File dataFile)
{
  dataFile.print(val);
  dataFile.print("  ");
  smartdelay(0);
} 
static void print_date(TinyGPS &gps, File dataFile)
{
  int year;
  byte month, day, hour, minute, second, hundredths;
  unsigned long age;
  gps.crack_datetime(&year, &month, &day, &hour, &minute, &second, &hundredths, &age);
  dataFile.print(day);
  dataFile.print("/");
  dataFile.print(month);
  dataFile.print("/");   
  dataFile.print(year);
  dataFile.print("  ");
  dataFile.print(hour+1);
  dataFile.print(":");
  dataFile.print(minute);
  dataFile.print(":");   
  dataFile.print(second); 
  dataFile.print("  ");
  smartdelay(0);
}

