//////////////////////////////////////////////////////////////////////////////
// LaserGames 
//
// Enthalten sind die Spiele Asteorieds und Pong.
// Daneben sind auch Testbilder und Beispiele für den Umgang mit 
// den Zeichenroutinen enthalten.
//
// veröffentlicht in der MAKE 6/2017
//
// Ulrich Schmerold
// 10/2017
//////////////////////////////////////////////////////////////////////////////

#include "Asteroids.h" // Variablen und Konstanten für das Spiel Asteorieds
#include "Pong.h"      // Variablen und Konstanten für das Spiel Pong
#include <Time.h>      // Bibliotek für die Uhr
#include "TimerOne.h"  // Timer für das Tackten der Galvoscanner
#define tonePin 2      // Pin, an dem der Lautsprecher angeschlossen wird
#define Schalter1 4    // Pins für Auswahl der Spiele und Testbilder (Pins Codierschalter)
#define Schalter2 5    //         - || -
#define Schalter3 6    //         - || -
#define Schalter4 7    //         - || -
int Switch;            // Variable für den Codierschalter

//------------------------ Globale Variablen für Galvo-Scanner und Draw------------------------------------
int current_pos_x;       // An welcher Position steht der Galvo gerade?
int current_pos_y;       //      - || -

int PointerSet = 0;      // An dieser Position wird in den Stram geschrieben (Befüül-Zeiger)
int PointerShow = 0;     // An dieser Position befindet sich gerade der Laser (oder gerauer die Galvo-Scanner)(AnzeigeZeiger)
int lastPoints = 99998; 
int VectorsPicture = 99999;                          
//---------------------------------------------------------------------------------------------------------



void setup() 
{ 
  pinMode(Schalter1, INPUT_PULLUP); 
  pinMode(Schalter2, INPUT_PULLUP); 
  pinMode(Schalter3, INPUT_PULLUP); 
  pinMode(Schalter4, INPUT_PULLUP); 
  setTime(1,20,0,1,10,2017); // Nur zum Testen der Uhr ==> Arduino müsste um eine DCF ergänzt werden
  Serial.begin(9600);
  randomSeed(analogRead(0)); // Zufallsfunktion initialisieren
  init_DAC(23);              // Initialisierung vom R2R Netzwerk und Timer für die Galvos (Tacktrate)
  init_Laser();
  init_Nunchuk();
  init_Asteroids();
  init_Pong();
}


void loop() 
{
   poll_switch();  // Codierschalter abfragen
                   // Wer keinen verbaut hat, aktiviert die folgende Zeile:
                   // Switch = 0; // .. oder eine andere Nummer angeben
        
   switch (Switch)
   {
     case 0: play_Pong();
      break;
     case 1: play_Asteroids();
      break;
     case 2: analogUhr();
      break;
     case 3: ShowIldaTestbild(); 
      break;
     case 4: Testbild_1();
      break;
     case 5: Testbild_2();  
      break;
     case 6: Testbild_3();
      break;
     case 7: Lauftext();
      break;
     case 8: Testbild_5();
      break;
     case 9: Annimation();
      break;
     case 10: showMake();
      break;
     case 11: showMake2();
      break;
     case 12: showMake3();
      break;
     case 13: showBild();
      break;
     case 14: showBild2();
      break;
     case 15: showTestpicture();
      break;
   }     
   
}


// Kodierschalter abfragen und in Integerwert umrechnen
void poll_switch()
{
  Switch =  digitalRead(Schalter1) + 2*digitalRead(Schalter2) + 4*digitalRead(Schalter3) + 8*digitalRead(Schalter4);
}







