//////////////////////////////////////////////////////////////////////////////
// Anzeigen einer analogen Uhr
//
// Das Ziffernblatt wird nur einmal berechnet und dem Stream übergeben.
// Die Zeiger werden dann immer von der Endposition des Ziffernblatts
// in den Stream geschrieben. Dadurch wird die Rechenzeit mit Winkelfunktionen verkleinert.
//
// Ulrich Schmerold
// 10/2017
// veröffentlicht in der MAKE 6/2017
//////////////////////////////////////////////////////////////////////////////
#define Durchmesser 60
int pointsUhr = 9999;
int SecondSaved;

void analogUhr()
{
   int Std = hour();
   int Min = minute(); 
   int Second = second();
   
   if  (pointsUhr != lastPoints) ZiffernblattRund(); // Daten nur neu laden, wenn sich die Punkteanzahl ändert.
    else behind = true;
   if (Second != SecondSaved)
    {
      PointerSet = pointsUhr; // Anstelle von beginFrame(), 
                          // dann muss das Ziffernblatt nicht neu konstruiert werden
   // Sundenzeiger
      byte color = 3;  // Farbe Gelb
      blanking( 100,100);
        double dx = 100- sin (0.01745*(16*(24-Std)-0.5*Min))*(Durchmesser-40);  
        double dy = 100- cos (0.01745*(16*(24-Std)-0.5*Min))*(Durchmesser-40);  
      DrawLine(dx, dy, color);
        dx = 100-sin (0.01745*(15*(24-Std)-0.5*Min))*(Durchmesser-20);  
        dy = 100-cos (0.01745*(15*(24-Std)-0.5*Min))*(Durchmesser-20);
      DrawLine( dx,dy, color);
        dx = 100-sin (0.01745*(14*(24-Std)-0.5*Min))*(Durchmesser-40);  
        dy = 100-cos (0.01745*(14*(24-Std)-0.5*Min))*(Durchmesser-40);
      DrawLine(dx, dy, color);
      DrawLine(100, 100, color);

    // Minutenzeiger
     color=2;   // Farbe Grün
      blanking( 100,100);
        dx = 100-sin (0.1047*(58-Min))*(Durchmesser-35);
        dy = 100-cos (0.1047*(58-Min))*(Durchmesser-35);
      DrawLine( dx,dy, color);
        dx=100- sin (0.1047*(60-Min))*(Durchmesser-10);
        dy=100- cos (0.1047*(60-Min))*(Durchmesser-10);
      DrawLine( dx,dy, color);
        dx=100- sin (0.1047*(2-Min))*(Durchmesser-35);
        dy=100- cos (0.1047*(2-Min))*(Durchmesser-35);
      DrawLine(dx, dy, color);
      DrawLine(100, 100, color);

    // Sekundenzeiger
    color=7;    // Farbe weiss
      blanking(100, 100);
        dx = 100-sin (0.1047*(60-Second))*(Durchmesser-10);
        dy = 100-cos (0.1047*(60-Second))*(Durchmesser-10);
      DrawLine(dx, dy, color);
    endFrame();
    SecondSaved = Second;
  } 
}

void ZiffernblattRund()
{
  beginFrame();  
  byte color = 1;   
        DrawCircle(100, 100, Durchmesser, 1);
         for (int i = 90; i < 450 ; i = i+30)
         {
          float sina = sin (0.01745*i);
          float cosa = cos (0.01745*i);
          double dx = 100+ sina*(Durchmesser-3);
          double dy= 100+ cosa*(Durchmesser-3);
          blanking(dx, dy);
           dx = 100+ sina*(Durchmesser-10);
           dy = 100+ cosa*(Durchmesser-10);
          DrawLine(dx, dy, color);
         }
    lastPoints=PointerSet;
   pointsUhr=PointerSet;
   
 endFrame(); 
}

void ZiffernblattMake()
{
 beginFrame();
  for (int i=0 ; i<points_MAKE; i++)
  {
    byte x = pgm_read_byte_near(px_MAKE+i);     // Vektoren aus dem Programmspeicher auslesen
    byte y = pgm_read_byte_near(py_MAKE+i);     //            - || -
    byte color = pgm_read_byte_near(pc_MAKE+i); //            - || -
    DrawLine(x, y,color); 
  }
  lastPoints = PointerSet;
  pointsUhr=PointerSet;
 endFrame();
}

