void setup_hardware_spi(void)
{
	byte clr;
  digitalWrite(SLAVESELECT,HIGH); //disable device
  SPCR = (1<<SPE)|(1<<MSTR)|(1<<CPHA);
  clr=SPSR;
  clr=SPDR;
  SPSR |= _BV(SPI2X);               // Leztes Byte zuerst senden
}

char spi_transfer(volatile char data)
{
  SPDR = data; // Start the transmission
  while (!(SPSR & (1<<SPIF))) {};// Wait the end of the transmission
}

void SetVoltage(short Voltage)
{
  Voltage = 24576 + 2*Voltage ;  //24576 = '0110000000000000'
  digitalWrite(SLAVESELECT,LOW);
    spi_transfer( highByte(Voltage) );
    spi_transfer( lowByte(Voltage) );
  digitalWrite(SLAVESELECT,HIGH);
}

