#include "Keyboard.h"
#include "HID.h"

void clean(const uint16_t period) {
  const uint32_t currentMillis = millis();
  while (millis() - currentMillis < 5000) {
    if (Serial.available())
      Serial.write(Serial.read());
  }
}

void setup() {
  // start + wait for serial debug in/output
  while (!Serial);
  Serial.begin(115200);
  Serial.println(F("Los geht's!"));

  Keyboard.begin();
}

void loop() {
  if (Serial.available()) {
    // discard all Serial bytes to avoid multiple sendings
    clean(100);

    // print an information back to the serial port
    Serial.println();
    Serial.println(F("Der Text wird in 5 Sekunden eingegeben."));

    // wait 5 seconds and discard all new in bytes to not crash the Arduino
    clean(5000);

    // same use as the official library, pretty much self explaining
    Keyboard.print(F("Geschrieben vom Arduino."));
  }
}
