// ----------------------------
// ---  Teeodohr            ---
// ---  Andreas Engel 2017  ---
// ----------------------------
// Angepasst an KENodohr 2017 Tobias Vogel

#include <Servo.h>

Servo Arm;              // Servo 1 zuweisen

int max_Winkel=65;     // maximaler Ohr Winkel. Je nach Tassen Höhe anpassen  
int min_Winkel=115;

int LED1=3;                 // LED 3 minuten
int LED2=5;                // LED 5 minuten
int LED3=6;               // LED 7 minuten
int EndSound=7;          // SoundModul an D7
int Time=3;             // Time for Tea in minuten
                       // Für die Startmelodie ein Lautsprecher an Pin A0 (Siehe "void sound" ganz unten)

void setup() {  
  pinMode(LED1, OUTPUT);         // LED 1
  pinMode(LED2, OUTPUT);        // LED 2
  pinMode(LED3, OUTPUT);       // LED 3
  pinMode(EndSound, OUTPUT);  // 
  pinMode(A1, INPUT);        // ON and minutes select switch
  pinMode(A2, INPUT);       // Start / Stop select switch

  analogWrite(LED1, 255);           // 3 Minuten LED einschalten
  analogWrite(LED2, 0);            // alle anderen aus
  analogWrite(LED3, 0);           // alle anderen aus
      
  Arm.attach(11);                  // attaches the servo Arm to pin D11 servo object
  Arm.write(min_Winkel);          // tell servo 1 to go to position "min_Winkel"

      sound(250); delay (60);     // Play Sound. Ready to make Tea
      sound(500); delay (60);
      sound(1000); delay (60);
      sound(1500); delay (60);
      sound(2000); delay (60);
      sound(250); delay (60);
      sound(500); delay (60);
      sound(1000); delay (60);
      sound(1500); delay (60);
      sound(2000); delay (60);
      sound(250); delay (60);
      sound(500); delay (60);
      sound(1000); delay (60);
      sound(1500); delay (60);
      sound(2000); delay (60);      
}

void loop() {

  if (analogRead(A1) > 900 ) SelectNextTime();    // Mit Taster 1 Zeit einstellen
  if (analogRead(A2) > 900 ) TeaTime() ;         // Mit Taster 2 Tea Time Starten

}
// ------------------------------------------------------------------
// ------------------------------------------------------------------
void SelectNextTime(){
  // Warten bis Taster losgelassen
  do { delay(20); }while (analogRead(A1)>500);
  
  // Zeit einstellen. 3,5,7,10 & 12 minuten
  switch (Time) {
    case 3:
      Time=5;
      analogWrite(LED1, 0);   // LED's
      analogWrite(LED2, 255);
      analogWrite(LED3, 0);
      break;
    case 5:
      Time=7;
      analogWrite(LED1, 0);   // LED's
      analogWrite(LED2, 0);
      analogWrite(LED3, 255);
      break;    
    case 7:
      Time=10;
      analogWrite(LED1, 255); // LED's
      analogWrite(LED2, 0);
      analogWrite(LED3, 255);
      break;
    case 10:
      Time=12;
      analogWrite(LED1, 0);   // LED's
      analogWrite(LED2, 255);
      analogWrite(LED3, 255);
      break;    
    case 12:
      Time=3;
      analogWrite(LED1, 255); // LED's
      analogWrite(LED2, 0);
      analogWrite(LED3, 0);
  }
}
// ----------------------------
void TeaTime () {
  // Warten bis Taster losgelassen
  do { delay(20); }while (analogRead(A2)>500);

  // Schleife für die Anzahl der Minuten
  for (int i = 1; i <= Time; i++){
    
    // Tee Beutel langsam abwärts bis zum eingestellten Winkel
    for (int p = min_Winkel; p >=max_Winkel; p--){
      Arm.write(p);
      delay(20);
    }   

    // Diese Schleife dauert 1minute.
    for (int x=0;x<=20;x++){
      
      // Kurz vor ende der Minute den Beutel anheben.
      if (x==19){
        for (int p = max_Winkel; p <=min_Winkel; p++){
          Arm.write(p);                                // tell servo 1 to go to position xx degree out of Tea slowly !!
          delay(20);
        }
      }
      
      // LED's fade in /out in increments of 5 points:
      for (int fadeValue = 15 ; fadeValue <= 250; fadeValue += 5) {
         analogWrite(LED1, fadeValue);
         analogWrite(LED2, 255-fadeValue);
         analogWrite(LED3, fadeValue);
        
         delay(30);                                      // wait for 30 milliseconds to see the dimming effect
        
        if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
       }

      // LED's fade in / out in increments of 5 points:
      for (int fadeValue = 250 ; fadeValue >= 15; fadeValue -= 5) {
        analogWrite(LED1, fadeValue);
        analogWrite(LED2, 255-fadeValue);
        analogWrite(LED3, fadeValue);
                delay(30);                                      // wait for 30 milliseconds to see the dimming effect
        if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
      }
      
      if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
    }
    if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
  }

  // Arm nach oben
  for (int p = max_Winkel; p >=min_Winkel; p--){
    Arm.write(p);
    delay(20);
  }

  // Warten bis Taster losgelassen
  do { delay(20); }while (analogRead(A2)>500);

  ON_OFF_Sound();         // Play sound ready to make Tea
  Time=3;                 // Zeit wieder auf 3 min.
  analogWrite(LED1, 255); // 3 Minuten LED einschalten
  analogWrite(LED2, 0);   // alle anderen aus
  analogWrite(LED3, 0);   // alle anderen aus
  Arm.write(min_Winkel);  // Arm auf Grundstellung
}

void ON_OFF_Sound(){
  digitalWrite(EndSound, HIGH);        // Pin "EndSound" auf HIGH Zum starten des Soundmoduls
  delay(200);                        
  digitalWrite(EndSound, LOW);       // Pin "EndSound" zurück auf LOW 
}

void sound(int frequency){
  tone(A0, frequency, 16);
}
