#include <SD.h>

const uint8_t CHIP_SELECT_PIN = 4;
const uint16_t BAUD_RATE = 9600;

File logDatei;

void setup() {
  Serial.begin(BAUD_RATE);

  if (!SD.begin(CHIP_SELECT_PIN)) {
    Serial.println("SD-Karte konnte nicht initialisiert werden.");
    return;
  }

  logDatei = SD.open("datalog.csv", FILE_WRITE);
  if (!logDatei) {
    Serial.println("Die Log-Datei konnte nicht geöffnet werden.");
    return;
  }
}

void loop() {
  const uint8_t MAX_PIN = 3;
  
  String sensorDaten = "";
  for (uint8_t analogPin = 0; analogPin < MAX_PIN; analogPin++) {
    uint16_t sensor = analogRead(analogPin);
    sensorDaten += String(sensor);
    if (analogPin < MAX_PIN - 1) {
      sensorDaten += ",";
    }
  }

  Serial.println(sensorDaten);
  logDatei.println(sensorDaten);
  logDatei.flush();
  delay(500);
}

