#include <SD.h>

const uint16_t BAUD_RATE = 9600;
const uint8_t CHIP_SELECT_PIN = 10;

void setup() {
  Serial.begin(BAUD_RATE);
  Serial.print("SD-Karte wird initialisiert... ");

  Sd2Card card;
  if (!card.init(SPI_HALF_SPEED, CHIP_SELECT_PIN)) {
    Serial.println("Die Karte konnte nicht initialisiert werden.");
    return;
  } else {
    Serial.println("Alles prima!");
  }

  Serial.print("\nKarten-Typ: ");
  switch (card.type()) {
    case SD_CARD_TYPE_SD1:
      Serial.println("SD V1");
      break;
    case SD_CARD_TYPE_SD2:
      Serial.println("SD V2");
      break;
    case SD_CARD_TYPE_SDHC:
      Serial.println("SDHC");
      break;
    default:
      Serial.println("Unbekannt");
  }

  SdVolume volume;
  if (!volume.init(card)) {
    Serial.println("Es konnte keine FAT16/FAT32-Partition gefunden werden.");
    return;
  }

  Serial.print("Dateisystem: FAT");
  Serial.println(volume.fatType(), DEC);
  Serial.println();

  uint64_t kapazitaet = volume.blocksPerCluster();
  kapazitaet *= volume.clusterCount();
  kapazitaet *= 512;

  Serial.print("Kapazität (Bytes): ");
  char buffer[100];
  sprintf(buffer, "%0ld", kapazitaet / 1000000L); 
  Serial.print(buffer);
  sprintf(buffer, "%0ld", kapazitaet % 1000000L); 
  Serial.println(buffer);

  Serial.print("Kapazität (KBytes): ");
  uint32_t kapazitaet_kb = kapazitaet /= 1024;
  Serial.println(kapazitaet_kb);
  Serial.print("Kapazität (MBytes): ");
  uint32_t kapazitaet_mb = kapazitaet_kb /= 1024;
  Serial.println(kapazitaet_mb);

  Serial.println("\nDie Karte enthält die folgenden Dateien: ");
  SdFile root;
  root.openRoot(volume);
  root.ls(LS_R | LS_DATE | LS_SIZE);
}

void loop() {}

