#include <SD.h>
#include "Adafruit_HDC1000.h"
#include "RTClib.h"

const uint8_t CHIP_SELECT_PIN = 10;
const uint16_t BAUD_RATE = 9600;

File logDatei;
RTC_DS1307 rtc;
Adafruit_HDC1000 hdc = Adafruit_HDC1000();

void setup() {
  pinMode(LED_BUILTIN, OUTPUT);
  Serial.begin(BAUD_RATE);

  if (!hdc.begin(0x43)) {
    Serial.println("Konnte Temperatursensor nicht finden.");
    return;
  }

  hdc.drySensor(); // Braucht 15 Sekunden!
  
  if (!rtc.begin()) {
    Serial.println("Konnte keine Uhr finden.");
    return;
  }

  if (!rtc.isrunning()) {
    Serial.println("Die Uhr läuft nicht.");
    // Die folgende Anweisung setzt die Uhrzeit auf die Zeit
    // zu der das Programm übersetzt wurde:
    // rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
    
    // Die folgende Anweisung setzt die Uhrzeit auf einen
    // festen Zeitpunkt. Der 2. Juli 2017, 15:59:00 wäre:
    // rtc.adjust(DateTime(2017, 7, 2, 15, 59, 0));
  }

  SdFile::dateTimeCallback(ermittle_zeitstempel);

  if (!SD.begin(CHIP_SELECT_PIN)) {
    Serial.println("SD-Karte konnte nicht initialisiert werden.");
    return;
  }

  logDatei = SD.open("datalog.csv", FILE_WRITE);
  if (!logDatei) {
    Serial.println("Die Log-Datei konnte nicht geöffnet werden.");
    return;
  }
}

void loop() {
  DateTime now = rtc.now();
  char buffer[11];
  sprintf(buffer, "%4d-%02d-%02d", now.year(), now.month(), now.day());
  logDatei.print(buffer);
  logDatei.print(",");
  sprintf(buffer, "%02d:%02d:%02d", now.hour(), now.minute(), now.second());
  logDatei.print(buffer);
  logDatei.print(",");

  String sensorDaten = ermittle_sensor_daten();
  Serial.println(sensorDaten);

  digitalWrite(LED_BUILTIN, HIGH);
  logDatei.println(sensorDaten);
  logDatei.flush();
  digitalWrite(LED_BUILTIN, LOW);
  delay(5000);
}

void ermittle_zeitstempel(uint16_t* datum, uint16_t* uhrzeit) {
  DateTime now = rtc.now();
  *datum = FAT_DATE(now.year(), now.month(), now.day());
  *uhrzeit = FAT_TIME(now.hour(), now.minute(), now.second());
}

String ermittle_sensor_daten() {
  String sensorDaten = "";
  sensorDaten += hdc.readTemperature();
  sensorDaten += ",";
  sensorDaten += hdc.readHumidity();
  return sensorDaten;
}

