
#define SENSORPIN A0
float T0=298.15;    // Nenntemperatur des NTC-Thermistors in Kelvin
  float R0=100000;    // Nennwiderstand des NTC-Thermistors in Ohm
  float B=3950;       // Materialkonstante B
  float RV=100000;    // Vorwiderstand in Ohm 
  float temp; 
  
void setup()
{
  Serial.begin(9600);
}


void loop()
{
  // Analog-Signal vom Eingang holen
  int   NTCSignal = analogRead(SENSORPIN);

  //Berechnung des NTC-Widerstandes
  float RN = RV * (1023.0 / NTCSignal -1);
  
  // Berechnung der Temperatur in Kelvin mit Materialkonstante B nach Steinhart-Hart-Gleichung;
  temp=T0 * B / (B + (T0) * log(RN / R0));
  
  //Umrechnung in °C
  temp=temp-273.15;
  
  //Ausgabe über serielle Schnittstelle -> USB
  Serial.print("Temperatur: ");Serial.print(temp);Serial.println(" C");
  delay(500);
}

